/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.WritableAssertionInfo;

final class AssertionsAdapter {
    private AssertionsAdapter() {
    }

    static <T> AbstractObjectAssert<?, T> assertThat(T actual) {
        return new ObjectAssert<T>(actual);
    }

    static <T> AbstractObjectAssert<?, T> assertThat(T actual, AssertionInfo info) {
        return AssertionsAdapter.withAssertInfo(AssertionsAdapter.assertThat(actual), info);
    }

    static <T> AbstractObjectArrayAssert<?, T> assertThat(T[] actual) {
        return new ObjectArrayAssert<T>(actual);
    }

    static <T> AbstractObjectArrayAssert<?, T> assertThat(T[] actual, AssertionInfo info) {
        return AssertionsAdapter.withAssertInfo(AssertionsAdapter.assertThat(actual), info);
    }

    static AbstractCharSequenceAssert<?, String> assertThat(String actual) {
        return new StringAssert(actual);
    }

    static AbstractCharSequenceAssert<?, String> assertThat(String actual, AssertionInfo info) {
        return AssertionsAdapter.withAssertInfo(AssertionsAdapter.assertThat(actual), info);
    }

    static AbstractIntegerAssert<?> assertThat(int actual) {
        return new IntegerAssert(actual);
    }

    static AbstractIntegerAssert<?> assertThat(int actual, AssertionInfo info) {
        return AssertionsAdapter.withAssertInfo(AssertionsAdapter.assertThat(actual), info);
    }

    static AbstractDoubleAssert<?> assertThat(double actual) {
        return new DoubleAssert(actual);
    }

    static AbstractDoubleAssert<?> assertThat(double actual, AssertionInfo info) {
        return AssertionsAdapter.withAssertInfo(AssertionsAdapter.assertThat(actual), info);
    }

    static AbstractBooleanAssert<?> assertThat(boolean actual) {
        return new BooleanAssert(actual);
    }

    static AbstractBooleanAssert<?> assertThat(boolean actual, AssertionInfo info) {
        return AssertionsAdapter.withAssertInfo(AssertionsAdapter.assertThat(actual), info);
    }

    static <T extends AbstractAssert<?, ?>> T withAssertInfo(T assertion, AssertionInfo info) {
        WritableAssertionInfo destInfo = assertion.getWritableAssertionInfo();
        destInfo.overridingErrorMessage(info.overridingErrorMessage());
        destInfo.description(info.description());
        destInfo.useRepresentation(info.representation());
        return assertion;
    }
}

