/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.verapdf.as.filters.io.ASBufferedInFilter;

public class EncryptionToolsRevision5_6 {
    public static byte[] getFileEncryptionKey(byte[] password, byte[] o, byte[] u, byte[] oe, byte[] ue, long revision) throws GeneralSecurityException {
        byte[] e;
        byte[] stringForSalt;
        byte[] hash = EncryptionToolsRevision5_6.computeHash(password, EncryptionToolsRevision5_6.getValSaltFromString(o), u, true, revision);
        boolean isUser = false;
        if (!Arrays.equals(hash, EncryptionToolsRevision5_6.getHashValueFromString(o))) {
            isUser = true;
            hash = EncryptionToolsRevision5_6.computeHash(password, EncryptionToolsRevision5_6.getValSaltFromString(u), u, false, revision);
            if (!Arrays.equals(hash, EncryptionToolsRevision5_6.getHashValueFromString(u))) {
                throw new GeneralSecurityException("Incorrect password: failed check of owner hash.");
            }
        }
        byte[] res = null;
        if (isUser) {
            stringForSalt = u;
            e = ue;
        } else {
            stringForSalt = o;
            e = oe;
        }
        if (e != null) {
            byte[] aesKey = EncryptionToolsRevision5_6.computeHash(password, EncryptionToolsRevision5_6.getKeySaltFromString(stringForSalt), u, !isUser, revision);
            EncryptionToolsRevision5_6.enableAES256();
            SecretKeySpec key = new SecretKeySpec(aesKey, "AES");
            Cipher aes = Cipher.getInstance("AES/CBC/NoPadding");
            aes.init(2, (Key)key, new IvParameterSpec(new byte[16]));
            res = aes.doFinal(e);
        }
        return res;
    }

    private static byte[] computeHash(byte[] password, byte[] salt, byte[] u, boolean isCheckingOwnerPassword, long revision) throws GeneralSecurityException {
        byte[] hashInput = ASBufferedInFilter.concatenate(password, password.length, salt, 8);
        if (isCheckingOwnerPassword) {
            hashInput = ASBufferedInFilter.concatenate(hashInput, hashInput.length, u, u.length);
        }
        int rounds = 0;
        byte[] k = EncryptionToolsRevision5_6.getSHAHash(256, hashInput);
        if (revision > 5L) {
            while (true) {
                byte[] sequence = ASBufferedInFilter.concatenate(password, password.length, k, k.length);
                if (isCheckingOwnerPassword) {
                    sequence = ASBufferedInFilter.concatenate(sequence, sequence.length, u, u.length);
                }
                byte[] k1 = EncryptionToolsRevision5_6.repeatString(sequence, 64);
                IvParameterSpec initializingVector = new IvParameterSpec(Arrays.copyOfRange(k, 16, 32));
                SecretKeySpec key = new SecretKeySpec(Arrays.copyOf(k, 16), "AES");
                Cipher aes = Cipher.getInstance("AES/CBC/NoPadding");
                aes.init(1, (Key)key, initializingVector);
                byte[] e = aes.doFinal(k1);
                int shaType = EncryptionToolsRevision5_6.getReminderByModulo3(Arrays.copyOf(e, 16));
                byte[] byArray = shaType == 0 ? EncryptionToolsRevision5_6.getSHAHash(256, e) : (k = shaType == 1 ? EncryptionToolsRevision5_6.getSHAHash(384, e) : EncryptionToolsRevision5_6.getSHAHash(512, e));
                if (rounds >= 63 && (e[e.length - 1] & 0xFF) <= rounds - 32) break;
                ++rounds;
            }
        }
        return Arrays.copyOf(k, 32);
    }

    public static void enableAES256() throws GeneralSecurityException {
        if (Cipher.getMaxAllowedKeyLength("AES") < 256) {
            try {
                Field restrictedField = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                Field[] fields = (Field[])getDeclaredFields0.invoke(Field.class, false);
                Field modifiersField = null;
                for (Field field : fields) {
                    if (!"modifiers".equals(field.getName())) continue;
                    modifiersField = field;
                    break;
                }
                if (modifiersField == null) {
                    throw new IllegalStateException("Field \"modifiers\" is not declared in java.lang.reflect.Field");
                }
                modifiersField.setAccessible(true);
                modifiersField.setInt(restrictedField, restrictedField.getModifiers() & 0xFFFFFFEF);
                modifiersField.setAccessible(false);
                restrictedField.setAccessible(true);
                restrictedField.set(null, Boolean.FALSE);
            }
            catch (Exception ex) {
                throw new GeneralSecurityException("Can't enable using of 256-bit key for AES encryption", ex);
            }
        }
    }

    private static byte[] repeatString(byte[] string, int amount) {
        byte[] res = new byte[string.length * amount];
        for (int i = 0; i < amount; ++i) {
            System.arraycopy(string, 0, res, i * string.length, string.length);
        }
        return res;
    }

    private static byte[] getSHAHash(int shaNum, byte[] message) throws NoSuchAlgorithmException {
        if (shaNum != 256 && shaNum != 384 && shaNum != 512) {
            throw new IllegalStateException("Can't use SHA-" + shaNum + " hash.");
        }
        String shaMD = "SHA-" + shaNum;
        MessageDigest md = MessageDigest.getInstance(shaMD);
        md.update(message);
        return md.digest();
    }

    private static byte[] getHashValueFromString(byte[] string) {
        return Arrays.copyOf(string, 32);
    }

    private static byte[] getValSaltFromString(byte[] string) {
        return Arrays.copyOfRange(string, 32, 40);
    }

    private static byte[] getKeySaltFromString(byte[] string) {
        return Arrays.copyOfRange(string, 40, 48);
    }

    private static int getReminderByModulo3(byte[] array) {
        int res = 0;
        for (byte b : array) {
            res += b & 0xFF;
        }
        return res % 3;
    }
}

