/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Token {
    private static final Map<String, Keyword> KEYWORDS = new HashMap<String, Keyword>();
    public Type type;
    public Keyword keyword;
    public long integer;
    public double real;
    private ByteArrayOutputStream token = new ByteArrayOutputStream();
    private boolean containsOnlyHex = true;
    private long hexCount = 0L;

    public void toKeyword() {
        this.type = Type.TT_KEYWORD;
        this.keyword = Token.getKeyword(this.getValue());
    }

    public void append(int c) {
        this.token.write(c);
    }

    public String getValue() {
        return new String(this.getByteValue(), StandardCharsets.ISO_8859_1);
    }

    public byte[] getByteValue() {
        return this.token.toByteArray();
    }

    public void clearValue() {
        this.token.reset();
    }

    public int getSize() {
        return this.token.size();
    }

    public static Keyword getKeyword(String keyword) {
        return KEYWORDS.get(keyword);
    }

    public boolean isContainsOnlyHex() {
        return this.containsOnlyHex;
    }

    public void setContainsOnlyHex(boolean containsOnlyHex) {
        this.containsOnlyHex = containsOnlyHex;
    }

    public Long getHexCount() {
        return this.hexCount;
    }

    public void setHexCount(Long hexCount) {
        this.hexCount = hexCount;
    }

    public void setByteValue(byte[] array) {
        this.clearValue();
        this.token.write(array, 0, array.length);
    }

    static {
        KEYWORDS.put("null", Keyword.KW_NULL);
        KEYWORDS.put("true", Keyword.KW_TRUE);
        KEYWORDS.put("false", Keyword.KW_FALSE);
        KEYWORDS.put("stream", Keyword.KW_STREAM);
        KEYWORDS.put("endstream", Keyword.KW_ENDSTREAM);
        KEYWORDS.put("obj", Keyword.KW_OBJ);
        KEYWORDS.put("endobj", Keyword.KW_ENDOBJ);
        KEYWORDS.put("R", Keyword.KW_R);
        KEYWORDS.put("n", Keyword.KW_N);
        KEYWORDS.put("f", Keyword.KW_F);
        KEYWORDS.put("xref", Keyword.KW_XREF);
        KEYWORDS.put("startxref", Keyword.KW_STARTXREF);
        KEYWORDS.put("trailer", Keyword.KW_TRAILER);
        KEYWORDS.put(null, Keyword.KW_NONE);
    }

    public static enum Keyword {
        KW_NONE,
        KW_NULL,
        KW_TRUE,
        KW_FALSE,
        KW_STREAM,
        KW_ENDSTREAM,
        KW_OBJ,
        KW_ENDOBJ,
        KW_R,
        KW_N,
        KW_F,
        KW_XREF,
        KW_STARTXREF,
        KW_TRAILER;

    }

    public static enum Type {
        TT_NONE,
        TT_KEYWORD,
        TT_INTEGER,
        TT_REAL,
        TT_LITSTRING,
        TT_HEXSTRING,
        TT_NAME,
        TT_OPENARRAY,
        TT_CLOSEARRAY,
        TT_OPENDICT,
        TT_CLOSEDICT,
        TT_EOF,
        TT_STARTPROC,
        TT_ENDPROC;

    }
}

