/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.operator;

import java.util.HashMap;
import java.util.Map;
import org.verapdf.operator.InlineImageOperator;

public class Operator {
    private static final Map<String, Operator> CACHED_OPERATORS = new HashMap<String, Operator>();
    private String operator;

    protected Operator(String operator) {
        this.operator = operator;
    }

    public static Operator getOperator(String operator) {
        if (operator.equals("BI") || operator.equals("ID")) {
            return new InlineImageOperator(operator);
        }
        if (CACHED_OPERATORS.containsKey(operator)) {
            return CACHED_OPERATORS.get(operator);
        }
        Operator result = new Operator(operator);
        CACHED_OPERATORS.put(operator, result);
        return result;
    }

    public String getOperator() {
        return this.operator;
    }

    public String toString() {
        return "PDFOperator{" + this.operator + '}';
    }
}

