/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosArray;
import org.verapdf.model.coslayer.CosObject;

public class GFCosArray
extends GFCosObject
implements CosArray {
    public static final String COS_ARRAY_TYPE = "CosArray";
    public static final String ELEMENTS = "elements";
    private final int size;

    public GFCosArray(COSArray array) {
        this(array, COS_ARRAY_TYPE);
    }

    public GFCosArray(COSArray array, String type) {
        super(array, type);
        this.size = array.size();
    }

    @Override
    public Long getsize() {
        return this.size;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (link.equals(ELEMENTS)) {
            return this.getElements();
        }
        return super.getLinkedObjects(link);
    }

    private List<CosObject> getElements() {
        ArrayList<CosObject> list = new ArrayList<CosObject>(this.getsize().intValue());
        for (COSObject object : (COSArray)this.baseObject) {
            if (object == null || object.get() == null) continue;
            list.add(GFCosArray.getFromValue(object.get()));
        }
        return Collections.unmodifiableList(list);
    }
}

