/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.LowLvlInfoFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class LowLvlInfoFeaturesObject
extends FeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(LowLvlInfoFeaturesObject.class.getCanonicalName());
    private static final String LOW_LEVEL_INFO = "lowLevelInfo";
    private static final String PDF_VERSION = "pdfVersion";
    private static final String INDIRECT_OBJECTS_NUMBER = "indirectObjectsNumber";
    private static final String DOCUMENT_ID = "documentId";
    private static final String CREATION_ID = "creationId";
    private static final String MOD_ID = "modificationId";
    private static final String TAGGED = "tagged";
    private static final String FILTERS = "filters";
    private static final String FILTER = "filter";
    private static final String NAME = "name";

    public LowLvlInfoFeaturesObject(LowLvlInfoFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.LOW_LEVEL_INFO;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        LowLvlInfoFeaturesObjectAdapter lowLvlAdapter = (LowLvlInfoFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(LOW_LEVEL_INFO);
        CreateNodeHelper.addNotEmptyNode(PDF_VERSION, this.getPDFVersionString(lowLvlAdapter), root);
        root.addChild(INDIRECT_OBJECTS_NUMBER).setValue(String.valueOf(lowLvlAdapter.getIndirectObjectsNumber()));
        String creationId = lowLvlAdapter.getCreationId();
        String modificationId = lowLvlAdapter.getModificationId();
        if (creationId != null || modificationId != null) {
            FeatureTreeNode documentId = root.addChild(DOCUMENT_ID);
            if (creationId != null) {
                documentId.setAttribute(CREATION_ID, creationId);
            }
            if (modificationId != null) {
                documentId.setAttribute(MOD_ID, modificationId);
            }
        }
        CreateNodeHelper.addNotEmptyNode(TAGGED, String.valueOf(lowLvlAdapter.isTagged()), root);
        Set<String> filters = lowLvlAdapter.getFilters();
        if (!filters.isEmpty()) {
            FeatureTreeNode filtersNode = root.addChild(FILTERS);
            for (String filter : filters) {
                if (filter == null) continue;
                FeatureTreeNode filterNode = filtersNode.addChild(FILTER);
                filterNode.setAttribute(NAME, filter);
            }
        }
        return root;
    }

    private String getPDFVersionString(LowLvlInfoFeaturesObjectAdapter lowLvlAdapter) {
        double res = lowLvlAdapter.getHeaderVersion();
        String catalogVersion = lowLvlAdapter.getCatalogVersion();
        if (catalogVersion != null) {
            try {
                double catalogValue = Double.valueOf(catalogVersion);
                res = Math.max(res, catalogValue);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, "Problems in obtaining pdf version number from the catalog", e);
            }
        }
        return CreateNodeHelper.formatDouble(res, 1);
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("PDF Version", LowLvlInfoFeaturesObject.generateVariableXPath(LOW_LEVEL_INFO, PDF_VERSION), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Indirect Objects Number", LowLvlInfoFeaturesObject.generateVariableXPath(LOW_LEVEL_INFO, INDIRECT_OBJECTS_NUMBER), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Creation ID", LowLvlInfoFeaturesObject.generateAttributeXPath(LOW_LEVEL_INFO, DOCUMENT_ID, CREATION_ID), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Modification ID", LowLvlInfoFeaturesObject.generateAttributeXPath(LOW_LEVEL_INFO, DOCUMENT_ID, MOD_ID), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Tagged", LowLvlInfoFeaturesObject.generateVariableXPath(LOW_LEVEL_INFO, TAGGED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Filter Name", LowLvlInfoFeaturesObject.generateAttributeXPath(LOW_LEVEL_INFO, FILTERS, FILTER, NAME), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", LowLvlInfoFeaturesObject.generateAttributeXPath(LOW_LEVEL_INFO, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

