/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.ActionFeaturesObjectAdapter;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class ActionFeaturesObject
extends FeaturesObject {
    private static final String ACTION = "action";
    private static final String TYPE = "type";
    private static final String LOCATION = "location";

    public ActionFeaturesObject(ActionFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.ACTION;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        this.errors.clear();
        if (this.adapter.isPDFObjectPresent()) {
            ActionFeaturesObjectAdapter actionAdapter = (ActionFeaturesObjectAdapter)this.adapter;
            String type = actionAdapter.getType();
            if (type == null) {
                return null;
            }
            FeatureTreeNode root = this.findRootForType(collection, type);
            if (root == null) {
                root = this.createNewRoot(collection, type);
            }
            this.addLocation(root, actionAdapter.getLocation());
            this.errors.addAll(this.adapter.getErrors());
            if (!this.errors.isEmpty()) {
                for (String error : this.errors) {
                    ErrorsHelper.addErrorIntoCollection(collection, root, error);
                }
            }
            return root;
        }
        return null;
    }

    private void addLocation(FeatureTreeNode root, ActionFeaturesObjectAdapter.Location location) throws FeatureParsingException {
        if (location != null) {
            List<FeatureTreeNode> children = root.getChildren();
            for (FeatureTreeNode child : children) {
                if (!LOCATION.equals(child.getName()) || !location.getText().equals(child.getValue())) continue;
                return;
            }
            FeatureTreeNode locationNode = root.addChild(LOCATION);
            locationNode.setValue(location.getText());
        }
    }

    private FeatureTreeNode createNewRoot(FeatureExtractionResult collection, String type) {
        FeatureTreeNode root = FeatureTreeNode.createRootNode(ACTION);
        root.setAttribute(TYPE, type);
        collection.addNewFeatureTree(this.getType(), root);
        return root;
    }

    private FeatureTreeNode findRootForType(FeatureExtractionResult collection, String type) {
        List<FeatureTreeNode> featureTreesForType = collection.getFeatureTreesForType(FeatureObjectType.ACTION);
        for (FeatureTreeNode node : featureTreesForType) {
            Map<String, String> attributes = node.getAttributes();
            String attrType = attributes.get(TYPE);
            if (!type.equals(attrType)) continue;
            return node;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Type", ActionFeaturesObject.generateAttributeXPath(ACTION, TYPE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Location", ActionFeaturesObject.generateAttributeXPath(ACTION, LOCATION), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", ActionFeaturesObject.generateAttributeXPath(ACTION, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

