/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.verapdf.core.MapBackedDirectory;
import org.verapdf.core.Registry;

public class MapBackedRegistry<K, V>
extends MapBackedDirectory<K, V>
implements Registry<K, V> {
    public MapBackedRegistry() {
        this(new HashMap());
    }

    public MapBackedRegistry(Map<K, V> map) {
        super(map);
    }

    @Override
    public V registerItem(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public void registerItems(Map<K, V> itemMap) {
        this.map.putAll(itemMap);
    }

    @Override
    public V removeItem(K key) {
        return this.map.remove(key);
    }

    @Override
    public void removeItems(Set<K> keys) {
        for (K key : keys) {
            this.map.remove(key);
        }
    }

    @Override
    public V putdateItem(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public void putdateItems(Map<K, V> itemMap) {
        this.map.putAll(itemMap);
    }

    @Override
    public V updateItem(K key, V value) {
        if (!this.map.containsKey(key)) {
            throw new NoSuchElementException();
        }
        return this.map.put(key, value);
    }

    @Override
    public void updateItems(Map<K, V> itemMap) {
        for (K key : itemMap.keySet()) {
            this.updateItem(key, itemMap.get(key));
        }
    }
}

