/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.finbin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class BinaryUtil {
    public static byte[] getBytes(String text) {
        byte[] bytes = new byte[]{};
        try {
            bytes = text.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return bytes;
    }

    public static void memcopy(byte[] dest, byte[] src, int copyToIndex) {
        System.arraycopy(src, 0, dest, copyToIndex, src.length);
    }

    public static byte[] loadBytesFromFile(File file) {
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBytesToFile(byte[] data, File file) {
        if (data == null) {
            return;
        }
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(data);
            ((BufferedOutputStream)bos).flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void print(byte[] array) {
        int i;
        String[] name = new String[]{"+0", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+a", "+b", "+c", "+d", "+e", "+f"};
        for (i = 0; i < 16; ++i) {
            System.out.print(name[i] + " ");
        }
        System.out.println();
        for (i = 0; i < array.length; ++i) {
            if (i != 0 && i % 16 == 0) {
                System.out.println();
            }
            byte b = array[i];
            System.out.print(String.format("%02x", b).toUpperCase() + " ");
        }
        System.out.println();
    }

    public static void printWithAscii(byte[] array) {
        int i;
        String[] name = new String[]{"+0", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+a", "+b", "+c", "+d", "+e", "+f"};
        for (i = 0; i < 16; ++i) {
            System.out.print(name[i] + " " + "   ");
        }
        System.out.println();
        for (i = 0; i < array.length; ++i) {
            if (i != 0 && i % 16 == 0) {
                System.out.println();
            }
            byte b = array[i];
            String str = " ";
            if (32 <= b && b <= 126) {
                str = String.valueOf((char)b);
            }
            System.out.print(String.format("%02x", b).toUpperCase() + "(" + str + ")" + " ");
        }
        System.out.println();
    }

    public static void printWithAsciiWithIndex(byte[] array) {
        int i;
        String[] name = new String[]{"+0", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+a", "+b", "+c", "+d", "+e", "+f"};
        for (i = 0; i < 16; ++i) {
            System.out.print(name[i] + " " + "   " + "     ");
        }
        System.out.println();
        for (i = 0; i < array.length; ++i) {
            if (i != 0 && i % 16 == 0) {
                System.out.println();
            }
            byte b = array[i];
            String str = " ";
            if (32 <= b && b <= 126) {
                str = String.valueOf((char)b);
            }
            System.out.print(String.format("%02x", b).toUpperCase() + "(" + str + ")" + "[" + String.format("%03d", i) + "]" + " ");
        }
        System.out.println();
    }
}

