/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.finbin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.riversun.finbin.BinarySearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigBinarySearcher
extends BinarySearcher {
    private static final int DEFAULT_MAX_NUM_OF_THREADS = 128;
    public static final int THREADS_NO_LIMIT = 0;
    private static final int DEFAULT_ANALYZE_BYTE_ARRAY_UNIT_SIZE = 512;
    private int analyzeByteArrayUnitSize = 512;
    private int maxNumOfThreads = 128;

    public void setBufferSize(int bufferSize) {
        this.analyzeByteArrayUnitSize = bufferSize;
    }

    public void setMaxNumOfThreads(int maxNumOfThreads) {
        this.maxNumOfThreads = maxNumOfThreads;
    }

    public List<Integer> searchBigBytes(byte[] srcBytes, byte[] searchBytes) {
        int numOfThreadsOptimized = srcBytes.length / this.analyzeByteArrayUnitSize;
        if (numOfThreadsOptimized == 0) {
            numOfThreadsOptimized = 1;
        }
        return this.searchBigBytes(srcBytes, searchBytes, numOfThreadsOptimized);
    }

    public List<Integer> searchBigBytes(byte[] srcBytes, byte[] searchBytes, int numOfThreads) {
        if (numOfThreads == 0) {
            numOfThreads = 1;
        }
        int sizeOfSrcBytes = srcBytes.length;
        int sizeOfSearchBytes = searchBytes.length;
        int bytesToReadBlockSize = (srcBytes.length - sizeOfSearchBytes) / numOfThreads;
        int threadPoolSize = this.maxNumOfThreads == 0 ? numOfThreads : this.maxNumOfThreads;
        ExecutorService executorService = Executors.newFixedThreadPool(threadPoolSize);
        ArrayList<Future<List<Integer>>> futureList = new ArrayList<Future<List<Integer>>>();
        for (int i = 0; i < numOfThreads; ++i) {
            int offset = bytesToReadBlockSize * i;
            int n = i == numOfThreads - 1 ? sizeOfSrcBytes - offset - 1 : bytesToReadBlockSize + sizeOfSearchBytes;
            Future<List<Integer>> future = executorService.submit(new BinarySearchTask(srcBytes, searchBytes, offset, n));
            futureList.add(future);
        }
        executorService.shutdown();
        CopyOnWriteArrayList<Integer> resultIndexList = new CopyOnWriteArrayList<Integer>();
        for (Future future : futureList) {
            try {
                List rawIndexList = (List)future.get();
                for (int i = 0; i < rawIndexList.size(); ++i) {
                    Integer integer = (Integer)rawIndexList.get(i);
                    if (resultIndexList.contains(integer)) continue;
                    resultIndexList.add(integer);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
        }
        resultIndexList.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer num1, Integer num2) {
                if (num1 > num2) {
                    return 1;
                }
                if (num1 < num2) {
                    return -1;
                }
                return 0;
            }
        });
        return resultIndexList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class BinarySearchTask
    implements Callable<List<Integer>> {
        final byte[] srcBytes;
        final byte[] searchBytes;
        final int offset;
        final int readLeng;

        BinarySearchTask(byte[] srcBytes, byte[] searchBytes, int offset, int readLeng) {
            this.srcBytes = srcBytes;
            this.offset = offset;
            this.readLeng = readLeng;
            this.searchBytes = searchBytes;
        }

        @Override
        public List<Integer> call() throws Exception {
            BinarySearcher binSearcher = new BinarySearcher();
            List<Integer> resultIndexList = binSearcher.searchBytes(this.srcBytes, this.searchBytes, this.offset, this.offset + this.readLeng);
            return resultIndexList;
        }
    }
}

