/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.bigdoc.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BasicSAXHandler
extends DefaultHandler {
    private TagEventListener mTagEventListener;
    private String mCurrentTagKey;
    private boolean mIsForceStop = false;
    private Stack<String> mTagStack = new Stack();
    private Map<String, StringBuilder> mTagValueCache = new HashMap<String, StringBuilder>();
    private Map<String, Attributes> mTagAttrCache = new HashMap<String, Attributes>();

    public void setTagEventListener(TagEventListener listener) {
        this.mTagEventListener = listener;
    }

    public void initialize() {
        this.mIsForceStop = false;
        this.mTagStack.clear();
        this.mTagValueCache.clear();
        this.mTagAttrCache.clear();
        this.mCurrentTagKey = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.mIsForceStop) {
            this.mIsForceStop = false;
            throw new BasicSAXHandlerException("Force stopped.");
        }
        this.mCurrentTagKey = this.getTagKey(namespaceURI, localName, qName);
        if (!this.mTagValueCache.containsKey(this.mCurrentTagKey)) {
            this.mTagValueCache.put(this.mCurrentTagKey, new StringBuilder());
            this.mTagAttrCache.put(this.mCurrentTagKey, atts);
        }
        this.pushTag(qName);
        String currentTag = this.getCurrentTag();
        if (this.mTagEventListener != null) {
            this.mTagEventListener.onTagStarted(currentTag, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.mCurrentTagKey == null) {
            return;
        }
        StringBuilder sb = this.mTagValueCache.get(this.mCurrentTagKey);
        String str = new String(ch, start, length);
        sb.append(str);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        String key = this.getTagKey(namespaceURI, localName, qName);
        StringBuilder sb = this.mTagValueCache.get(key);
        Attributes atts = this.mTagAttrCache.get(key);
        String value = null;
        if (sb != null) {
            value = sb.toString();
        }
        this.mTagValueCache.remove(key);
        this.mTagAttrCache.remove(key);
        this.mCurrentTagKey = null;
        String currentTag = this.getCurrentTag();
        this.popTag();
        if (this.mTagEventListener != null) {
            this.mTagEventListener.onTagFinished(currentTag, qName, value, atts);
        }
    }

    public void forceStop() {
        this.mIsForceStop = true;
    }

    private String getCurrentTag() {
        if (!this.mTagStack.empty()) {
            return this.mTagStack.peek();
        }
        return "";
    }

    private void pushTag(String qName) {
        String currentTag = this.getCurrentTag();
        if ("".equals(currentTag)) {
            this.mTagStack.push(qName);
        } else {
            this.mTagStack.push(this.getCurrentTag() + "." + qName);
        }
    }

    private void popTag() {
        this.mTagStack.pop();
    }

    private String getTagKey(String namespaceURI, String localName, String qName) {
        return namespaceURI + "_" + localName + "_" + qName;
    }

    public static class BasicSAXHandlerException
    extends SAXException {
        public BasicSAXHandlerException(String message) {
            super(message);
        }
    }

    public static interface TagEventListener {
        public void onTagStarted(String var1, String var2);

        public void onTagFinished(String var1, String var2, String var3, Attributes var4);
    }
}

