/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.bigdoc.bin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.riversun.bigdoc.bin.BinFileSearcher;

public class BigFileSearcher {
    private ProgressCache progressCache;
    private boolean useOptimization = true;
    private final BinFileSearcher binFileSearcher = new BinFileSearcher();
    public static final int DEFAULT_MAX_NUM_OF_THREADS = 24;
    public static final int THREADS_NO_LIMIT = 0;
    public static final int DEFAULT_BLOCK_SIZE = 0xA00000;
    private int bufferSizePerWorker = 0x100000;
    private int subThreadSize = 32;
    private int subBufferSize = 512;
    private long blockSize = 0xA00000L;
    private int maxNumOfThreads = 24;
    private OnProgressListener onProgressListener;
    private OnRealtimeResultListener onRealtimeResultListener;
    private long _profile_lastStartTime;
    private long _profile_lastEndTime;

    public void setUseOptimization(boolean enabled) {
        this.useOptimization = enabled;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public void setBufferSizePerWorker(int bufferSize) {
        this.bufferSizePerWorker = bufferSize;
    }

    public void setMaxNumOfThreads(int maxNumOfThreads) {
        this.maxNumOfThreads = maxNumOfThreads;
    }

    public void setSubThreadSize(int subThreadSize) {
        this.subThreadSize = subThreadSize;
    }

    public void setSubBufferSize(int subBufferSize) {
        this.subBufferSize = subBufferSize;
    }

    public Long indexOf(File f, byte[] searchBytes) {
        return this.indexOf(f, searchBytes, 0L);
    }

    public Long indexOf(File f, byte[] searchBytes, long fromPosition) {
        return this.binFileSearcher.indexOf(f, searchBytes, fromPosition);
    }

    public List<Long> searchBigFileRealtime(File f, byte[] searchBytes, OnRealtimeResultListener listener) {
        return this.searchBigFileRealtime(f, searchBytes, 0L, listener);
    }

    public List<Long> searchBigFileRealtime(File f, byte[] searchBytes, long startPosition, OnRealtimeResultListener listener) {
        this.onRealtimeResultListener = listener;
        this.onProgressListener = null;
        int numOfThreadsOptimized = (int)(f.length() / this.blockSize);
        if (numOfThreadsOptimized == 0) {
            numOfThreadsOptimized = 1;
        }
        long fileLen = f.length();
        this.optimize(fileLen);
        this.setMaxNumOfThreads(1);
        this.setBlockSize(fileLen);
        return this.searchBigFile(f, searchBytes, numOfThreadsOptimized, false, startPosition);
    }

    public List<Long> searchBigFile(File f, byte[] searchBytes) {
        return this.searchBigFile(f, searchBytes, null);
    }

    public List<Long> searchBigFile(File f, byte[] searchBytes, OnProgressListener listener) {
        this.onRealtimeResultListener = null;
        this.onProgressListener = listener;
        int numOfThreadsOptimized = (int)(f.length() / this.blockSize);
        if (numOfThreadsOptimized == 0) {
            numOfThreadsOptimized = 1;
        }
        return this.searchBigFile(f, searchBytes, numOfThreadsOptimized, this.useOptimization, 0L);
    }

    private List<Long> searchBigFile(File srcFile, byte[] searchBytes, int numOfThreads, boolean useOptimization, long startPosition) {
        this.progressCache = null;
        if (useOptimization) {
            this.optimize(srcFile.length());
        }
        this._profile_lastStartTime = System.currentTimeMillis();
        if (numOfThreads == 0) {
            numOfThreads = 1;
        }
        long sizeOfSrcBytes = srcFile.length();
        int sizeOfSearchBytes = searchBytes.length;
        long bytesToReadBlockSize = (sizeOfSrcBytes - (long)sizeOfSearchBytes) / (long)numOfThreads;
        int threadPoolSize = this.maxNumOfThreads == 0 ? numOfThreads : this.maxNumOfThreads;
        ExecutorService executorService = Executors.newFixedThreadPool(threadPoolSize);
        ArrayList<Future<List<Long>>> futureList = new ArrayList<Future<List<Long>>>();
        int i = 0;
        while (i < numOfThreads) {
            long l = bytesToReadBlockSize * (long)i + startPosition;
            long readLeng = i == numOfThreads - 1 ? sizeOfSrcBytes - l : bytesToReadBlockSize + (long)sizeOfSearchBytes;
            BinFileProgressListenerEx progressListener = this.onProgressListener == null && this.onRealtimeResultListener == null ? null : new BinFileProgressListenerEx(){

                @Override
                public void onProgress(int workerNumber, int workerSize, List<Long> pointerList, float progress) {
                    BigFileSearcher.this.onProgress(workerNumber, workerSize, pointerList, progress);
                }
            };
            int workerSize = numOfThreads;
            int workerNumber = i++;
            Future<List<Long>> future = executorService.submit(new BigFileSearchTask(srcFile, searchBytes, l, readLeng, workerNumber, workerSize, progressListener));
            futureList.add(future);
        }
        executorService.shutdown();
        CopyOnWriteArrayList<Long> resultIndexList = new CopyOnWriteArrayList<Long>();
        for (Future future : futureList) {
            try {
                List rawIndexList = (List)future.get();
                int i2 = 0;
                while (i2 < rawIndexList.size()) {
                    Long longVal = (Long)rawIndexList.get(i2);
                    if (!resultIndexList.contains(longVal)) {
                        resultIndexList.add(longVal);
                    }
                    ++i2;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        this.binFileSearcher.sort(resultIndexList);
        this._profile_lastEndTime = System.currentTimeMillis();
        return resultIndexList;
    }

    private void onProgress(int workerNumber, int workerSize, List<Long> pointerList, float progress) {
        if (this.progressCache == null) {
            this.progressCache = new ProgressCache(workerSize, this.onRealtimeResultListener != null);
        }
        this.progressCache.setProgress(workerNumber, progress, pointerList);
        if (this.onProgressListener != null) {
            this.onProgressListener.onProgress(this.progressCache.getProgress());
        }
        if (this.onRealtimeResultListener != null) {
            this.onRealtimeResultListener.onRealtimeResultListener(this.progressCache.getProgress(), this.progressCache.getResultPointers());
        }
    }

    public long getEllapsedMillis() {
        return this._profile_lastEndTime - this._profile_lastStartTime;
    }

    public void _showProfile() {
        System.out.println("availableProcessors=" + Runtime.getRuntime().availableProcessors() + " free memory=" + this.getMegaBytes(Runtime.getRuntime().freeMemory()));
        System.out.println("worker blockSize=" + this.getMegaBytes(this.blockSize) + " " + "worker buffer Size=" + this.getMegaBytes(this.bufferSizePerWorker) + ", " + "max num of thread=" + this.maxNumOfThreads + ", " + "sub buffer size=" + this.subBufferSize + "(B)" + ", " + "sub thread size=" + this.subThreadSize + ", ");
        System.out.println("possible max thread=" + this.maxNumOfThreads * this.subThreadSize + " " + "possible max memory=" + this.getMegaBytes(this.bufferSizePerWorker * this.maxNumOfThreads + this.subBufferSize * this.subThreadSize));
    }

    private void optimize(long fileLength) {
        long blockSize;
        long bufferSize;
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        long free = Runtime.getRuntime().freeMemory() / 2L;
        int workerSize = availableProcessors / 2;
        if (workerSize < 2) {
            workerSize = 2;
        }
        if ((bufferSize = free / (long)workerSize) > 0x100000L) {
            bufferSize = 0x100000L;
        }
        if ((blockSize = fileLength / (long)workerSize) > 0x100000L) {
            blockSize = 0x100000L;
        }
        int iBlockSize = (int)blockSize;
        if (bufferSize > blockSize) {
            bufferSize = blockSize;
        }
        int iBufferSize = (int)bufferSize;
        this.setBlockSize(iBlockSize);
        this.setMaxNumOfThreads(workerSize);
        this.setBufferSizePerWorker(iBufferSize);
        this.setSubBufferSize(256);
    }

    private String getMegaBytes(long valBytes) {
        return String.format("%.1f(MB)", Float.valueOf((float)valBytes / 1048576.0f));
    }

    private final class BigFileSearchTask
    implements Callable<List<Long>> {
        final int workerSize;
        final int workerNumber;
        final File srcFile;
        final byte[] searchBytes;
        final long startPostion;
        final long readLeng;
        final BinFileProgressListenerEx binFileProgressListener;

        BigFileSearchTask(File srcFile, byte[] searchBytes, long startPosition, long readLeng, int workerNumber, int workerSize, BinFileProgressListenerEx listener) {
            this.srcFile = srcFile;
            this.startPostion = startPosition;
            this.readLeng = readLeng;
            this.searchBytes = searchBytes;
            this.binFileProgressListener = listener;
            this.workerNumber = workerNumber;
            this.workerSize = workerSize;
        }

        @Override
        public List<Long> call() throws Exception {
            BinFileSearcher blockSearchWorker = new BinFileSearcher();
            blockSearchWorker.setBufferSize(BigFileSearcher.this.bufferSizePerWorker);
            blockSearchWorker.setSubThreadSize(BigFileSearcher.this.subThreadSize);
            blockSearchWorker.setSubBufferSize(BigFileSearcher.this.subBufferSize);
            if (this.binFileProgressListener != null) {
                blockSearchWorker.setBigFileProgressListener(new BinFileSearcher.BinFileProgressListener(){

                    @Override
                    public void onProgress(List<Long> pointerList, float progress, float currentPosition, float startPosition, long maxSizeToRead) {
                        BigFileSearchTask.this.binFileProgressListener.onProgress(BigFileSearchTask.this.workerNumber, BigFileSearchTask.this.workerSize, pointerList, progress);
                    }
                });
            }
            List<Long> pointerList = blockSearchWorker.searchPartially(this.srcFile, this.searchBytes, this.startPostion, this.readLeng);
            return pointerList;
        }
    }

    private static interface BinFileProgressListenerEx {
        public void onProgress(int var1, int var2, List<Long> var3, float var4);
    }

    public static interface OnProgressListener {
        public void onProgress(float var1);
    }

    public static interface OnRealtimeResultListener {
        public void onRealtimeResultListener(float var1, List<Long> var2);
    }

    static final class ProgressCache {
        volatile float[] progress;
        volatile List<Long>[] pointerList;
        final List<Long> resultPointerList = new ArrayList<Long>();
        final boolean useResultCache;
        final int workerSize;

        ProgressCache(int workerSize, boolean useResultCache) {
            this.workerSize = workerSize;
            this.progress = new float[workerSize];
            this.useResultCache = useResultCache;
            if (useResultCache) {
                this.pointerList = new CopyOnWriteArrayList[workerSize];
            }
        }

        synchronized void setProgress(int workerNumber, float progress, List<Long> pointerList) {
            this.progress[workerNumber] = progress;
            if (this.useResultCache) {
                if (this.pointerList[workerNumber] == null) {
                    this.pointerList[workerNumber] = new CopyOnWriteArrayList<Long>();
                }
                this.pointerList[workerNumber].clear();
                this.pointerList[workerNumber].addAll(pointerList);
            }
        }

        List<Long> getResultPointers() {
            this.resultPointerList.clear();
            int i = 0;
            while (i < this.pointerList.length) {
                this.resultPointerList.addAll(this.pointerList[i]);
                ++i;
            }
            return this.resultPointerList;
        }

        float getProgress() {
            float progress = 0.0f;
            int i = 0;
            while (i < this.workerSize) {
                progress += this.progress[i];
                ++i;
            }
            return progress / (float)this.workerSize;
        }
    }
}

