/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.XMLTools;
import org.mustangproject.validator.ByteArraySearcher;
import org.mustangproject.validator.EPart;
import org.mustangproject.validator.ESeverity;
import org.mustangproject.validator.IrrecoverableValidationError;
import org.mustangproject.validator.PDFValidator;
import org.mustangproject.validator.ValidationContext;
import org.mustangproject.validator.ValidationResultItem;
import org.mustangproject.validator.XMLValidator;
import org.riversun.bigdoc.bin.BigFileSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ZUGFeRDValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDValidator.class.getCanonicalName());
    protected ValidationContext context = new ValidationContext(LOGGER);
    protected String sha1Checksum;
    protected boolean pdfValidity;
    protected boolean displayXMLValidationOutput;
    protected long startTime;
    protected boolean optionsRecognized;
    protected boolean disableNotices = false;
    protected String Signature;
    protected boolean wasCompletelyValid = false;
    protected String logAppend = null;

    public boolean hasOptionsError() {
        return !this.optionsRecognized;
    }

    public void setLogAppend(String tobeappended) {
        this.logAppend = tobeappended;
    }

    public boolean wasCompletelyValid() {
        return this.wasCompletelyValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate(String filename) {
        boolean isPDF;
        StringBuffer finalStringResult;
        block27: {
            this.context.clear();
            finalStringResult = new StringBuffer();
            SimpleDateFormat isoDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            this.startTime = Calendar.getInstance().getTimeInMillis();
            try {
                Path path = Paths.get(filename, new String[0]);
                this.context.setFilename(path.getFileName().toString());
            }
            catch (NullPointerException path) {
                // empty catch block
            }
            finalStringResult.append("<validation filename='" + this.context.getFilename() + "' datetime='" + isoDF.format(date) + "'>");
            isPDF = false;
            byte[] content = null;
            try {
                byte[] pdfSignature;
                if (filename == null) {
                    this.optionsRecognized = false;
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "Filename not specified").setSection(10).setPart(EPart.pdf));
                }
                PDFValidator pdfv = new PDFValidator(this.context);
                File file = new File(filename);
                if (!file.exists()) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "File not found").setSection(1).setPart(EPart.pdf));
                    break block27;
                }
                if (file.length() < 32L) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "File too small").setSection(5).setPart(EPart.pdf));
                    break block27;
                }
                BigFileSearcher searcher = new BigFileSearcher();
                content = Files.readAllBytes(file.toPath());
                XMLValidator xv = new XMLValidator(this.context);
                if (this.disableNotices) {
                    xv.disableNotices();
                }
                boolean bl = isPDF = searcher.indexOf(file, pdfSignature = new byte[]{37, 80, 68, 70}) == 0L;
                if (isPDF) {
                    pdfv.setFilename(filename);
                    pdfv.setFileContents(content);
                    this.optionsRecognized = true;
                    try {
                        if (!file.exists()) {
                            this.context.addResultItem(new ValidationResultItem(ESeverity.exception, "File " + filename + " not found").setSection(1));
                        }
                    }
                    catch (IrrecoverableValidationError irrecoverableValidationError) {
                        // empty catch block
                    }
                    finalStringResult.append("<pdf>");
                    this.optionsRecognized = true;
                    try {
                        pdfv.validate();
                        this.sha1Checksum = ZUGFeRDValidator.calcSHA1(new FileInputStream(file));
                        this.getPdfValidationResults(finalStringResult, pdfv, xv);
                    }
                    catch (FileNotFoundException | IrrecoverableValidationError exception) {
                        // empty catch block
                    }
                    finalStringResult.append("</pdf>\n");
                    this.context.clearCustomXML();
                } else {
                    boolean isXML = false;
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        content = XMLTools.removeBOM(content);
                        String s = new String(content, StandardCharsets.UTF_8);
                        InputSource is = new InputSource(new StringReader(s));
                        org.w3c.dom.Document doc = db.parse(is);
                        Element root = doc.getDocumentElement();
                        isXML = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (isXML) {
                        this.pdfValidity = true;
                        this.optionsRecognized = true;
                        xv.setFilename(filename);
                        if (file.exists()) {
                            this.sha1Checksum = ZUGFeRDValidator.calcSHA1(Files.newInputStream(file.toPath(), new OpenOption[0]));
                        }
                        this.displayXMLValidationOutput = true;
                    } else {
                        this.optionsRecognized = false;
                        this.context.addResultItem(new ValidationResultItem(ESeverity.exception, "File does not look like PDF nor XML (contains neither %PDF nor <?xml)").setSection(8));
                    }
                }
                if (this.optionsRecognized && this.displayXMLValidationOutput) {
                    finalStringResult.append("<xml>");
                    try {
                        xv.validate();
                    }
                    catch (IrrecoverableValidationError irrecoverableValidationError) {
                        // empty catch block
                    }
                    finalStringResult.append(xv.getXMLResult());
                    finalStringResult.append("</xml>");
                    this.context.clearCustomXML();
                }
                if (isPDF && !this.pdfValidity) {
                    this.context.setInvalid();
                }
            }
            catch (IOException | IrrecoverableValidationError exception) {
            }
            finally {
                finalStringResult.append(this.context.getXMLResult());
                finalStringResult.append("</validation>");
            }
        }
        return this.formatOutput(finalStringResult, isPDF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate(InputStream inputStream, String fileNameOfInputStream) {
        boolean isPDF;
        StringBuffer finalStringResult;
        block20: {
            this.context.clear();
            finalStringResult = new StringBuffer();
            SimpleDateFormat isoDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            this.startTime = Calendar.getInstance().getTimeInMillis();
            this.context.setFilename(fileNameOfInputStream);
            finalStringResult.append("<validation filename='").append(this.context.getFilename()).append("' datetime='").append(isoDF.format(date)).append("'>");
            isPDF = false;
            byte[] content = new byte[]{};
            try {
                if (fileNameOfInputStream == null) {
                    this.optionsRecognized = false;
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "Filename not specified").setSection(10).setPart(EPart.pdf));
                }
                PDFValidator pdfv = new PDFValidator(this.context);
                if (inputStream == null) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "File not found").setSection(1).setPart(EPart.pdf));
                    break block20;
                }
                if (inputStream.available() < 32) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "File too small").setSection(5).setPart(EPart.pdf));
                    break block20;
                }
                content = IOUtils.toByteArray(inputStream);
                isPDF = ByteArraySearcher.contains(content, new byte[]{37, 80, 68, 70});
                XMLValidator xv = new XMLValidator(this.context);
                if (isPDF) {
                    pdfv.setFilename(fileNameOfInputStream);
                    pdfv.setFileContents(content);
                    this.optionsRecognized = true;
                    finalStringResult.append("<pdf>");
                    try {
                        pdfv.validate();
                        this.sha1Checksum = ZUGFeRDValidator.calcSHA1(inputStream);
                        this.getPdfValidationResults(finalStringResult, pdfv, xv);
                    }
                    catch (IrrecoverableValidationError irx) {
                        LOGGER.info(irx.getMessage());
                    }
                    finalStringResult.append("</pdf>\n");
                    this.context.clearCustomXML();
                } else {
                    boolean isXML = false;
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        content = XMLTools.removeBOM(content);
                        String s = new String(content, StandardCharsets.UTF_8);
                        InputSource is = new InputSource(new StringReader(s));
                        org.w3c.dom.Document doc = db.parse(is);
                        Element root = doc.getDocumentElement();
                        isXML = true;
                    }
                    catch (Exception ex) {
                        LOGGER.info("No XML part provided");
                    }
                    if (isXML) {
                        this.pdfValidity = true;
                        this.optionsRecognized = true;
                        xv.setFilename(fileNameOfInputStream);
                        this.sha1Checksum = ZUGFeRDValidator.calcSHA1(inputStream);
                        this.displayXMLValidationOutput = true;
                    } else {
                        this.optionsRecognized = false;
                        this.context.addResultItem(new ValidationResultItem(ESeverity.exception, "File does not look like PDF nor XML (contains neither %PDF nor <?xml)").setSection(8));
                    }
                }
                if (this.optionsRecognized && this.displayXMLValidationOutput) {
                    finalStringResult.append("<xml>");
                    try {
                        xv.validate();
                    }
                    catch (IrrecoverableValidationError irx) {
                        LOGGER.info("The hell");
                    }
                    finalStringResult.append(xv.getXMLResult());
                    finalStringResult.append("</xml>");
                    this.context.clearCustomXML();
                }
                if (isPDF && !this.pdfValidity) {
                    this.context.setInvalid();
                }
            }
            catch (IOException | IrrecoverableValidationError irx) {
                LOGGER.info(irx.getMessage());
            }
            finally {
                finalStringResult.append(this.context.getXMLResult());
                finalStringResult.append("</validation>");
            }
        }
        return this.formatOutput(finalStringResult, isPDF);
    }

    private void getPdfValidationResults(StringBuffer finalStringResult, PDFValidator pdfv, XMLValidator xv) throws IrrecoverableValidationError {
        finalStringResult.append(pdfv.getXMLResult());
        this.pdfValidity = this.context.isValid();
        this.Signature = this.context.getSignature();
        this.context.clear();
        if (pdfv.getRawXML() != null) {
            xv.setStringContent(pdfv.getRawXML());
            this.displayXMLValidationOutput = true;
        } else {
            this.context.addResultItem(new ValidationResultItem(ESeverity.exception, "XML could not be extracted").setSection(17));
        }
    }

    private String formatOutput(StringBuffer finalStringResult, boolean isPDF) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText(new String(finalStringResult));
        }
        catch (DocumentException e1) {
            LOGGER.error(e1.getMessage());
        }
        XMLWriter writer = new XMLWriter(sw, format);
        try {
            writer.write(document);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        boolean xmlValidity = this.context.isValid();
        long duration = Calendar.getInstance().getTimeInMillis() - this.startTime;
        String toBeAppended = "";
        if (this.logAppend != null) {
            toBeAppended = this.logAppend;
        }
        String pdfResult = "invalid";
        if (!isPDF) {
            pdfResult = "absent";
        } else if (this.pdfValidity) {
            pdfResult = "valid";
        }
        LOGGER.info("Parsed PDF:" + pdfResult + " XML:" + (xmlValidity ? "valid" : "invalid") + " Signature:" + this.Signature + " Checksum:" + this.sha1Checksum + " Profile:" + this.context.getProfile() + " Version:" + this.context.getGeneration() + " Took:" + duration + "ms Errors:[" + this.context.getCSVResult() + "] " + toBeAppended);
        this.wasCompletelyValid = this.pdfValidity && xmlValidity;
        return sw.toString();
    }

    public void disableNotices() {
        this.disableNotices = true;
    }

    private static String calcSHA1(InputStream inputStream) {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[8192];
            int len = inputStream.read(buffer);
            while (len != -1) {
                sha1.update(buffer, 0, len);
                len = inputStream.read(buffer);
            }
            inputStream.close();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), e);
        }
        if (sha1 == null) {
            return "";
        }
        return new HexBinaryAdapter().marshal(sha1.digest());
    }
}

