/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import org.mustangproject.XMLTools;
import org.mustangproject.validator.EPart;
import org.mustangproject.validator.ESeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationResultItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationResultItem.class.getCanonicalName());
    protected String message;
    protected String location = null;
    protected int section = -1;
    private ESeverity severity = ESeverity.error;
    private String criterion = null;
    private String stacktrace = null;
    private boolean hasBeenOutputted = false;
    private EPart part;
    private XMLTools xt;

    public ValidationResultItem(ESeverity sev, String msg) {
        this.setSeverity(sev);
        this.setMessage(msg);
        this.xt = new XMLTools();
    }

    public ValidationResultItem setMessage(String msg) {
        this.message = msg;
        return this;
    }

    public ValidationResultItem setSection(int sec) {
        this.section = sec;
        return this;
    }

    public ValidationResultItem setLocation(String loc) {
        this.location = loc;
        return this;
    }

    public ValidationResultItem setPart(EPart loc) {
        this.part = loc;
        return this;
    }

    public EPart getPart() {
        return this.part;
    }

    public ValidationResultItem setSeverity(ESeverity sev) {
        this.severity = sev;
        return this;
    }

    public ValidationResultItem setStacktrace(String stack) {
        this.stacktrace = stack;
        return this;
    }

    public String getXML() {
        String tagname = "error";
        if (this.severity == ESeverity.exception) {
            tagname = "exception";
        } else if (this.severity == ESeverity.warning) {
            tagname = "warning";
        } else if (this.severity == ESeverity.notice) {
            tagname = "notice";
        }
        String additionalAttributes = "";
        String additionalContents = "";
        if (this.section != -1) {
            additionalAttributes = additionalAttributes + " type=\"" + this.section + "\"";
        }
        if (this.location != null) {
            additionalAttributes = additionalAttributes + " location=\"" + this.xt.escapeAttributeEntities(this.location) + "\"";
        }
        if (this.criterion != null) {
            additionalAttributes = additionalAttributes + " criterion=\"" + this.xt.escapeAttributeEntities(this.criterion) + "\"";
        }
        if (this.stacktrace != null) {
            additionalContents = additionalContents + "<stacktrace>" + this.xt.escapeAttributeEntities(this.stacktrace) + "</stacktrace>";
        }
        this.hasBeenOutputted = true;
        return "<" + tagname + additionalAttributes + ">" + this.xt.escapeElementEntities(this.message + additionalContents) + "</" + tagname + ">";
    }

    public String getXMLOnce() {
        if (!this.hasBeenOutputted) {
            return this.getXML();
        }
        return "";
    }

    public ValidationResultItem setCriterion(String test) {
        this.criterion = test;
        return this;
    }

    public ESeverity getSeverity() {
        return this.severity;
    }

    public int getSection() {
        return this.section;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocation() {
        return this.location;
    }
}

