/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SchematronPipeline {
    static final ClassLoader cl = SchematronPipeline.class.getClassLoader();
    private static final TransformerFactory factory = SchematronPipeline.getTransformerFactory();
    private static final String xslExt = ".xsl";
    private static final String resourcePath = "iso-schematron-xslt2/";
    private static final String isoDsdlXsl = "iso-schematron-xslt2/iso_dsdl_include.xsl";
    private static final String isoExpXsl = "iso-schematron-xslt2/iso_abstract_expand.xsl";
    private static final String isoSvrlXsl = "iso-schematron-xslt2/iso_svrl_for_xslt2.xsl";
    private static final Templates cachedIsoDsdXsl = SchematronPipeline.createCachedTransform("iso-schematron-xslt2/iso_dsdl_include.xsl");
    private static final Templates cachedExpXsl = SchematronPipeline.createCachedTransform("iso-schematron-xslt2/iso_abstract_expand.xsl");
    private static final Templates cachedIsoSvrlXsl = SchematronPipeline.createCachedTransform("iso-schematron-xslt2/iso_svrl_for_xslt2.xsl");

    private static TransformerFactory getTransformerFactory() {
        TransformerFactory fact = TransformerFactory.newInstance();
        fact.setURIResolver(new ClasspathResourceURIResolver());
        return fact;
    }

    static Templates createCachedTransform(String transName) {
        try {
            return factory.newTemplates(new StreamSource(cl.getResourceAsStream(transName)));
        }
        catch (TransformerConfigurationException excep) {
            throw new IllegalStateException("Policy Schematron transformer XSL " + transName + " not found.", excep);
        }
    }

    public static void processSchematron(InputStream schematronSource, OutputStream xslDest) throws TransformerException, IOException {
        File isoDsdResult = SchematronPipeline.createTempFileResult(cachedIsoDsdXsl.newTransformer(), new StreamSource(schematronSource), "IsoDsd");
        File isoExpResult = SchematronPipeline.createTempFileResult(cachedExpXsl.newTransformer(), new StreamSource(isoDsdResult), "ExpXsl");
        cachedIsoSvrlXsl.newTransformer().transform(new StreamSource(isoExpResult), new StreamResult(xslDest));
        isoDsdResult.delete();
        isoExpResult.delete();
    }

    private static File createTempFileResult(Transformer transformer, StreamSource toTransform, String suffix) throws TransformerException, IOException {
        File result = File.createTempFile("ZUV_", suffix);
        result.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(result);){
            transformer.transform(toTransform, new StreamResult(fos));
        }
        return result;
    }

    public static void applySchematronXsl(InputStream xmlFile, OutputStream policyReport) throws TransformerException {
        Transformer transformer = factory.newTransformer(new StreamSource(cl.getResourceAsStream("iso-schematron-xslt2/ZUGFeRDSchematronStylesheetXSLT1.xsl")));
        transformer.transform(new StreamSource(xmlFile), new StreamResult(policyReport));
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(cl.getResourceAsStream("iso-schematron-xslt2/xslt/" + href));
        }
    }
}

