/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.commandline;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mustangproject.validator.ZUGFeRDValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.assertj.XmlAssert;

public class ValidatorFileWalker
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatorFileWalker.class.getCanonicalName());
    protected PathMatcher matcher;
    protected ZUGFeRDValidator zul = new ZUGFeRDValidator();
    protected int fileCount = 1;
    protected boolean expectValid = true;
    protected boolean allValid = true;

    public ValidatorFileWalker(boolean expectValid) {
        this.expectValid = expectValid;
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:*.{pdf,xml}");
    }

    public boolean getResult() {
        return this.allValid;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String expectedString = "valid";
        if (!this.expectValid) {
            expectedString = "invalid";
        }
        if (attr != null && attr.isRegularFile() && this.matcher.matches(file.getFileName())) {
            boolean thisResultValid = true;
            String thisResultString = "  valid";
            try {
                XmlAssert.assertThat(this.zul.validate(file.toAbsolutePath().toString())).valueByXPath("/validation/summary/@status").asString().isEqualTo(expectedString);
            }
            catch (AssertionError ae) {
                thisResultValid = false;
                thisResultString = "invalid";
                this.allValid = false;
            }
            LOGGER.info(String.format("\n@%s Testing file %d: %s (%s)", dateFormat.format(date), this.fileCount++, thisResultString, file));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        LOGGER.info("\nDirectory: %s%n", (Object)dir);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        LOGGER.error(exc.getMessage(), exc);
        return FileVisitResult.CONTINUE;
    }
}

