/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.mustangproject.CII.CIIToUBL;
import org.mustangproject.EStandard;
import org.mustangproject.FileAttachment;
import org.mustangproject.ZUGFeRD.DXExporterFromA1;
import org.mustangproject.ZUGFeRD.IZUGFeRDExporter;
import org.mustangproject.ZUGFeRD.OXExporterFromA1;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.XMLUpgrader;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromA1;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromA3;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromPDFA;
import org.mustangproject.ZUGFeRD.ZUGFeRDImporter;
import org.mustangproject.ZUGFeRD.ZUGFeRDVisualizer;
import org.mustangproject.commandline.FileChecker;
import org.mustangproject.commandline.FileTraverser;
import org.mustangproject.commandline.StatRun;
import org.mustangproject.commandline.ValidatorFileWalker;
import org.mustangproject.validator.ZUGFeRDValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Logger LOGGER;

    private static void printUsage() {
        System.err.println(Main.getUsage());
    }

    private static String getUsage() {
        return "Usage: --action metrics|combine|extract|a3only|ubl|validate|validateExpectInvalid|validateExpectValid|visualize [-d,--directory] [-l,--listfromstdin] [-i,--ignore fileextension, PDF/A errors] [--disable-file-logging] | [-h,--help] \r\n        --action license   display open source license and notice\n        --action metrics\n          -d, --directory count ZUGFeRD files in directory to be scanned\n                If it is a directory, it will recurse.\n          -l, --listfromstdin     count ZUGFeRD files from a list of linefeed separated files on runtime.\n                It will start once a blank line has been entered.\n\n        Additional parameter for both count operations\n        [-i, --ignorefileextension]     Check for all files (*.*) instead of PDF files only (*.pdf) in metrics, ignore PDF/A input file errors in combine\n        [--disable-file-logging]\t\tdisable logging to file.\n        --action extract   extract Factur-X PDF to XML file\n                Additional parameters (optional - user will be prompted if not defined)\n                [--source <filename>]: set input PDF file\n                [--out <filename>]: set output XML file\n        --action a3only    upgrade from PDF/A1 to A3 only (no ZUGFeRD data attached)\n                Additional parameters (optional - user will be prompted if not defined)\n                [--source <filename>]: set input PDF file\n                [--out <filename>]: set output PDF file\n        --action combine   combine XML and PDF file to Factur-X PDF file\n                Additional parameters (optional - user will be prompted if not defined)\n                [--source <filename>]: set input PDF file\n                [--source-xml <filename>]: set input XML file\n                [--out <filename>]: set output PDF file\n                [--format <fx|zf|ox|da>]: set Factur-X, ZUGFeRD, Order-X or Cross Industry Despatch Advice\n                [--version <1|2>]: set ZUGFeRD version\n                [--profile <...>]: set ZUGFeRD profile\n                        For ZUGFeRD v1 or Order-X: <B>ASIC, <C>OMFORT or EX<T>ENDED\n                        For ZUGFeRD v2: <M>INIMUM, BASIC <W>L, <B>ASIC, <C>IUS, <E>N16931, <X>Rechnung, EX<T>ENDED\n                [--attachments <filenames>]: list of file attachments (passing a single empty file name prevents prompting)\n        --action ubl   convert UN/CEFACT 2016b CII XML to UBL XML\n                [--source <filename>]: set input XML file\n                [--out <filename>]: set output XML file\n        --action upgrade   upgrade ZUGFeRD XML to ZUGFeRD 2 XML\n                Additional parameters (optional - user will be prompted if not defined)\n                [--source <filename>]: set input XML ZUGFeRD 1 file\n                [--out <filename>]: set output XML ZUGFeRD 2 file\n        --action validate  validate XML or PDF file \n                [--no-notices]: refrain from reporting notices\n                [--logAppend <text>]: text to be added to log line\n                Additional parameters (optional - user will be prompted if not defined)\n                [--source <filename>]: input PDF or XML file\n        --action validateExpectInvalid  validate directory expecting negative results \n                [--no-notices]: refrain from reporting notices\n                Additional parameters (optional - user will be prompted if not defined)\n\t\t\t\t\t-d, --directory to check recursively\n        --action validateExpectValid  validate directory expecting positive results \n                [--no-notices]: refrain from reporting notices\n                Additional parameters (optional - user will be prompted if not defined)\n\t\t\t\t\t-d, --directory to check recursively \n        --action visualize  convert XML to HTML \n                [--language <lang>]: set output lang (en, fr or de)\n                [--source <filename>]: set input XML file\n                [--out <filename>]: set output HTML file\n        --action pdf  convert XML to PDF \n                [--source <filename>]: set input XML file\n                [--out <filename>]: set output PDF file\n";
    }

    private static void printHelp() {
        System.out.println("Mustangproject.org 2.11.0 \r\nA Apache Public License tool for e-invoices with\r\nZUGFeRD Metadata (http://www.zugferd.org)\r\n\r\n" + Main.getUsage() + "\r\n");
    }

    protected static String getStringFromUser(String prompt, String defaultValue, String pattern) throws Exception {
        String input = "";
        if (!defaultValue.matches(pattern)) {
            throw new Exception("Default value must match pattern");
        }
        boolean firstInput = true;
        do {
            System.out.print(prompt + " (default: " + defaultValue + ")");
            if (!firstInput && pattern.length() > 0) {
                System.out.print("\n(allowed pattern: " + pattern + ")");
            }
            System.out.print(":");
            BufferedReader buffer = new BufferedReader(new InputStreamReader(System.in));
            try {
                input = buffer.readLine();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
            if (input.isEmpty()) {
                input = defaultValue;
            }
            firstInput = false;
        } while (!input.matches(pattern));
        return input;
    }

    protected static String getFilenameFromUser(String prompt, String defaultFilename, String expectedExtension, boolean ensureFileExists, boolean ensureFileNotExists) {
        boolean fileExistenceOK = false;
        String selectedName = "";
        do {
            String[] expectedExtensions;
            System.out.print(prompt + (defaultFilename.isEmpty() ? ":" : " (default: " + defaultFilename + "):"));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(System.in));
            try {
                selectedName = buffer.readLine();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
            if (selectedName.isEmpty()) {
                if (defaultFilename.isEmpty()) {
                    return "";
                }
                selectedName = defaultFilename;
            }
            boolean hasCorrectExtension = false;
            for (String currentExtension : expectedExtensions = expectedExtension.split("\\|")) {
                if (!selectedName.toLowerCase().endsWith(currentExtension.toLowerCase())) continue;
                hasCorrectExtension = true;
                break;
            }
            if (ensureFileExists) {
                if (Main.fileExists(selectedName).booleanValue()) {
                    fileExistenceOK = true;
                    continue;
                }
                System.out.println("File does not exist, try again or CTRL+C to cancel");
                fileExistenceOK = false;
                continue;
            }
            if (!hasCorrectExtension) {
                System.err.println("Expected " + expectedExtension + " extension, this may corrupt your file. Do you still want to continue?(Y|N)");
                String selectedAnswer = "";
                try {
                    selectedAnswer = buffer.readLine();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), e);
                }
                if (selectedAnswer.equals("Y") || selectedAnswer.equals("y")) continue;
                System.err.println("Aborted by user");
                System.exit(-1);
                continue;
            }
            fileExistenceOK = true;
            if (ensureFileNotExists) {
                if (!Main.fileExists(selectedName).booleanValue()) continue;
                fileExistenceOK = false;
                System.out.println("Output file already exists, try again or CTRL+C to cancel");
                continue;
            }
            fileExistenceOK = true;
        } while (!fileExistenceOK);
        return selectedName;
    }

    private static void performUpgrade(String xmlName, String outName) throws IOException, TransformerException {
        if (xmlName == null) {
            xmlName = Main.getFilenameFromUser("ZUGFeRD 1.0 XML source", "ZUGFeRD-invoice.xml", "xml", true, false);
        } else {
            System.out.println("ZUGFeRD 1.0 XML source set to " + xmlName);
        }
        if (outName == null) {
            outName = Main.getFilenameFromUser("ZUGFeRD 2.0 XML target", "factur-x.xml", "xml", false, true);
        } else {
            System.out.println("ZUGFeRD 2 XML target to " + outName);
        }
        Main.ensureFileExists(xmlName);
        Main.ensureFileNotExists(outName);
        XMLUpgrader zmi = new XMLUpgrader();
        String xml = zmi.migrateFromV1ToV2(xmlName);
        Files.write(Paths.get(outName, new String[0]), xml.getBytes(), new OpenOption[0]);
        System.out.println("Written to " + outName);
    }

    private static void performUBL(String xmlName, String outName) throws IOException, TransformerException {
        if (xmlName == null) {
            xmlName = Main.getFilenameFromUser("Factur-X XML source", "factur-x.xml", "xml", true, false);
        } else {
            System.out.println("Factur-X XML source set to " + xmlName);
        }
        if (outName == null) {
            outName = Main.getFilenameFromUser("UBL target", "ubl-invoice.xml", "xml", false, true);
        } else {
            System.out.println("UBL target to " + outName);
        }
        Main.ensureFileExists(xmlName);
        Main.ensureFileNotExists(outName);
        CIIToUBL c2u = new CIIToUBL();
        c2u.convert(new File(xmlName), new File(outName));
        System.out.println("Written to " + outName);
    }

    public static void printLicense() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("LICENSE");
        System.out.println(Main.convertInputStreamToString(is));
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("NOTICE");
        System.out.println(Main.convertInputStreamToString(is));
    }

    private static String convertInputStreamToString(InputStream is) {
        int DEFAULT_BUFFER_SIZE = 8192;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            BasicParser parser = new BasicParser();
            Options options = new Options();
            options.addOption(new Option("h", "help", false, "display usage"));
            options.addOption(new Option("a", "action", true, "which action to perform"));
            options.addOption(new Option("f", "format", true, "which format to output"));
            options.addOption(new Option("", "version", true, "which version of the standard to use"));
            options.addOption(new Option("", "profile", true, "which profile of the standard to use"));
            Option attachmentOpt = new Option("", "attachments", true, "File attachments");
            attachmentOpt.setValueSeparator(',');
            attachmentOpt.setArgs(-2);
            options.addOption(attachmentOpt);
            options.addOption(new Option("", "source", true, "which source file to use"));
            options.addOption(new Option("", "source-xml", true, "which source file to use"));
            options.addOption(new Option("", "language", true, "output language (en, de or fr)"));
            options.addOption(new Option("", "out", true, "which output file to write to"));
            options.addOption(new Option("", "no-notices", false, "suppress non-fatal errors"));
            options.addOption(new Option("", "logAppend", true, "freeform text to be appended to log messages"));
            options.addOption(new Option("", "disable-file-logging", false, "suppress logging to file"));
            options.addOption(new Option("d", "directory", true, "which directory to operate on"));
            options.addOption(new Option("i", "ignorefileextension", false, "ignore non-matching file extensions"));
            options.addOption(new Option("l", "listfromstdin", false, "take list of files from commandline"));
            boolean optionsRecognized = false;
            String action = "";
            Boolean disableFileLogging = false;
            try {
                CommandLine cmd = parser.parse(options, args);
                action = cmd.getOptionValue("action");
                String directoryName = cmd.getOptionValue("directory");
                Boolean filesFromStdIn = cmd.hasOption("listfromstdin");
                Boolean ignoreFileExt = cmd.hasOption("ignorefileextension");
                Boolean helpRequested = cmd.hasOption("help") || action != null && action.equals("help");
                disableFileLogging = cmd.hasOption("disable-file-logging");
                String sourceName = cmd.getOptionValue("source");
                String sourceXMLName = cmd.getOptionValue("source-xml");
                String outName = cmd.getOptionValue("out");
                String format = cmd.getOptionValue("format");
                String lang = cmd.getOptionValue("language");
                Boolean noNotices = cmd.hasOption("no-notices");
                String zugferdVersion = cmd.getOptionValue("version");
                String zugferdProfile = cmd.getOptionValue("profile");
                String[] attachmentFilenames = cmd.hasOption("attachments") ? cmd.getOptionValues("attachments") : null;
                ArrayList<FileAttachment> attachments = new ArrayList<FileAttachment>();
                System.setProperty("FILE_APPENDER_ENABLED", Boolean.valueOf(disableFileLogging == false).toString());
                LOGGER = LoggerFactory.getLogger("ROOT");
                if (helpRequested.booleanValue()) {
                    Main.printHelp();
                    optionsRecognized = true;
                } else if (action != null && action.equals("metrics")) {
                    Main.performMetrics(directoryName, filesFromStdIn, ignoreFileExt);
                    optionsRecognized = true;
                } else if (action != null && action.equals("combine")) {
                    Main.performCombine(sourceName, sourceXMLName, outName, format, zugferdVersion, zugferdProfile, ignoreFileExt, attachmentFilenames, attachments);
                    optionsRecognized = true;
                } else if (action != null && action.equals("extract")) {
                    Main.performExtract(sourceName, outName);
                    optionsRecognized = true;
                } else if (action != null && action.equals("a3only")) {
                    Main.performConvert(sourceName, outName);
                    optionsRecognized = true;
                } else if (action != null && action.equals("pdf")) {
                    Main.performVisualization(sourceName, lang, outName, true);
                    optionsRecognized = true;
                } else if (action != null && action.equals("visualize")) {
                    Main.performVisualization(sourceName, lang, outName, false);
                    optionsRecognized = true;
                } else if (action != null && action.equals("upgrade")) {
                    Main.performUpgrade(sourceName, outName);
                    optionsRecognized = true;
                } else if (action != null && action.equals("ubl")) {
                    Main.performUBL(sourceName, outName);
                    optionsRecognized = true;
                } else if (action != null && action.equals("validate")) {
                    optionsRecognized = Main.performValidate(sourceName, noNotices != null && noNotices != false, cmd.getOptionValue("logAppend"));
                } else if (action != null && action.equals("validateExpectValid")) {
                    optionsRecognized = Main.performValidateExpect(true, directoryName);
                } else if (action != null && action.equals("validateExpectInvalid")) {
                    optionsRecognized = Main.performValidateExpect(false, directoryName);
                }
            }
            catch (UnrecognizedOptionException ex) {
                optionsRecognized = false;
            }
            if (!optionsRecognized) {
                Main.printUsage();
                System.exit(2);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            System.exit(-1);
        }
    }

    private static boolean performValidate(String sourceName, boolean noNotices, String logAppend) {
        boolean optionsRecognized;
        if (sourceName == null) {
            sourceName = Main.getFilenameFromUser("Source PDF or XML", "invoice.pdf", "pdf|xml", true, false);
        }
        ZUGFeRDValidator zfv = new ZUGFeRDValidator();
        if (logAppend != null && logAppend.length() > 0) {
            zfv.setLogAppend(logAppend);
        }
        if (noNotices) {
            zfv.disableNotices();
        }
        System.out.println(zfv.validate(sourceName));
        boolean bl = optionsRecognized = !zfv.hasOptionsError();
        if (!zfv.wasCompletelyValid()) {
            System.exit(-1);
        }
        return optionsRecognized;
    }

    private static boolean performValidateExpect(boolean valid, String dirName) {
        ValidatorFileWalker zfWalk = new ValidatorFileWalker(valid);
        Path startingDir = Paths.get(dirName, new String[0]);
        try {
            Files.walkFileTree(startingDir, zfWalk);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String totalResult = "valid";
        if (!zfWalk.getResult()) {
            totalResult = "invalid";
            System.exit(-1);
        }
        System.out.println("Overall test result: " + totalResult);
        return true;
    }

    private static void performConvert(String pdfName, String outName) throws IOException {
        if (pdfName == null) {
            pdfName = Main.getFilenameFromUser("Source PDF", "invoice.pdf", "pdf", true, false);
        } else {
            System.out.println("Source PDF set to " + pdfName);
        }
        if (outName == null) {
            outName = Main.getFilenameFromUser("Target PDF", "invoice.a3.pdf", "pdf", false, true);
        } else {
            System.out.println("Target PDF set to " + outName);
        }
        Main.ensureFileExists(pdfName);
        Main.ensureFileNotExists(outName);
        ZUGFeRDExporterFromA1 ze = new ZUGFeRDExporterFromA1().convertOnly().load(pdfName);
        ze.export(outName);
        System.out.println("Written to " + outName);
    }

    private static void performExtract(String pdfName, String xmlName) throws IOException {
        if (pdfName == null) {
            pdfName = Main.getFilenameFromUser("Source PDF", "invoice.pdf", "pdf", true, false);
        } else {
            System.out.println("Source PDF set to " + pdfName);
        }
        if (xmlName == null) {
            xmlName = Main.getFilenameFromUser("ZUGFeRD XML", "factur-x.xml", "xml", false, true);
        } else {
            System.out.println("ZUGFeRD XML set to " + pdfName);
        }
        Main.ensureFileExists(pdfName);
        Main.ensureFileNotExists(xmlName);
        ZUGFeRDImporter zi = new ZUGFeRDImporter(pdfName);
        byte[] XMLContent = zi.getRawXML();
        if (XMLContent == null) {
            System.err.println("No ZUGFeRD XML found in PDF file");
        } else {
            Files.write(Paths.get(xmlName, new String[0]), XMLContent, new OpenOption[0]);
            System.out.println("Written to " + xmlName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void performCombine(String pdfName, String xmlName, String outName, String format, String zfVersion, String zfProfile, Boolean ignoreInputErrors, String[] attachmentFilenames, ArrayList<FileAttachment> attachments) throws Exception {
        try {
            Profile zfConformanceLevelProfile;
            int zfIntVersion;
            block59: {
                String attachmentFilename;
                zfIntVersion = 2;
                zfConformanceLevelProfile = Profiles.getByName("EXTENDED");
                if (pdfName == null) {
                    pdfName = Main.getFilenameFromUser("Source PDF", "invoice.pdf", "pdf", true, false);
                } else {
                    System.out.println("Source PDF set to " + pdfName);
                }
                if (xmlName == null) {
                    xmlName = Main.getFilenameFromUser("ZUGFeRD XML", "factur-x.xml", "xml", true, false);
                } else {
                    System.out.println("ZUGFeRD XML set to " + xmlName);
                }
                if (outName == null) {
                    outName = Main.getFilenameFromUser("Output PDF", "invoice.ZUGFeRD.pdf", "pdf", false, true);
                } else {
                    System.out.println("Output PDF set to " + outName);
                }
                if (attachmentFilenames == null) {
                    byte[] attachmentContents = null;
                    attachmentFilename = Main.getFilenameFromUser("Additional file attachments filename (empty for none)", "", "pdf", true, false);
                    if (attachmentFilename.length() != 0) {
                        attachmentContents = Files.readAllBytes(Paths.get(attachmentFilename, new String[0]));
                        String attachmentMime = Files.probeContentType(Paths.get(attachmentFilename, new String[0]));
                        attachments.add(new FileAttachment(attachmentFilename, attachmentMime, "Data", attachmentContents));
                    }
                } else {
                    for (int i = 0; i < attachmentFilenames.length; ++i) {
                        attachmentFilename = attachmentFilenames[i];
                        if (attachmentFilename.isEmpty()) continue;
                        byte[] attachmentContents = Files.readAllBytes(Paths.get(attachmentFilename, new String[0]));
                        String attachmentMime = Files.probeContentType(Paths.get(attachmentFilename, new String[0]));
                        attachments.add(new FileAttachment(attachmentFilename, attachmentMime, "Data", attachmentContents));
                    }
                }
                if (format == null) {
                    try {
                        format = Main.getStringFromUser("Format (fx=Factur-X, zf=ZUGFeRD, ox=Order-X, da=Cross Industry Despatch Advice)", "zf", "fx|zf|ox|da");
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                } else {
                    System.out.println("Format set to " + format);
                }
                if (zfVersion == null) {
                    try {
                        zfVersion = Main.getStringFromUser("Version (1 or 2)", Integer.toString(2), "1|2");
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                } else {
                    System.out.println("Version set to " + zfVersion);
                }
                zfIntVersion = Integer.valueOf(zfVersion);
                if (zfProfile == null) {
                    try {
                        if (format.equals("zf") && zfIntVersion == 1 || format.equals("ox")) {
                            zfProfile = Main.getStringFromUser("Profile (b)asic, (c)omfort or ex(t)ended", "t", "B|b|C|c|T|t");
                            break block59;
                        }
                        if (format.equals("da")) {
                            zfProfile = Main.getStringFromUser("Profile (p)ilot", "p", "P|p");
                            break block59;
                        }
                        zfProfile = Main.getStringFromUser("Profile  [M]INIMUM, BASIC [W]L, [B]ASIC,\n[C]IUS, [E]N16931, EX[T]ENDED or [X]RECHNUNG", "E", "M|m|W|w|B|b|C|c|E|e|T|t|X|x|");
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                } else {
                    System.out.println("Profile set to " + zfProfile);
                }
            }
            zfProfile = zfProfile.toLowerCase();
            Main.ensureFileExists(pdfName);
            Main.ensureFileExists(xmlName);
            Main.ensureFileNotExists(outName);
            if (format.equals("fx") && zfIntVersion > 1) {
                throw new Exception("Factur-X is only available in version 1 (roughly corresponding to ZF2)");
            }
            EStandard standard = EStandard.facturx;
            if (format.equals("zf")) {
                standard = EStandard.zugferd;
            }
            if (format.equals("da")) {
                standard = EStandard.despatchadvice;
                zfConformanceLevelProfile = Profiles.getByName(standard, "PILOT", 1);
            } else if (format.equals("zf") && zfIntVersion == 1 || format.equals("ox")) {
                if (format.equals("ox")) {
                    standard = EStandard.orderx;
                }
                if (zfProfile.equals("b")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "BASIC", zfIntVersion);
                } else if (zfProfile.equals("c")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "COMFORT", zfIntVersion);
                } else {
                    if (!zfProfile.equals("t")) throw new Exception(String.format("Unknown ZUGFeRD profile '%s'", zfProfile));
                    zfConformanceLevelProfile = Profiles.getByName(standard, "EXTENDED", zfIntVersion);
                }
            } else {
                if ((!format.equals("zf") || zfIntVersion != 2) && !format.equals("fx")) throw new Exception(String.format("Unknown version '%i'", zfIntVersion));
                if (zfProfile.equals("m")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "MINIMUM", zfIntVersion);
                } else if (zfProfile.equals("w")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "BASICWL", zfIntVersion);
                } else if (zfProfile.equals("b")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "BASIC", zfIntVersion);
                } else if (zfProfile.equals("c")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "CIUS", zfIntVersion);
                } else if (zfProfile.equals("e")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "EN16931", zfIntVersion);
                } else if (zfProfile.equals("t")) {
                    zfConformanceLevelProfile = Profiles.getByName(standard, "EXTENDED", zfIntVersion);
                } else {
                    if (!zfProfile.equals("x")) throw new Exception(String.format("Unknown ZUGFeRD profile '%s'", zfProfile));
                    zfConformanceLevelProfile = Profiles.getByName(standard, "XRECHNUNG", zfIntVersion);
                }
            }
            IZUGFeRDExporter ze = null;
            if (format.equals("ox")) {
                ze = new OXExporterFromA1().setProducer("Mustang-cli").setZUGFeRDVersion(zfIntVersion).setCreator(System.getProperty("user.name")).setProfile(zfConformanceLevelProfile);
                if (ignoreInputErrors.booleanValue()) {
                    ((OXExporterFromA1)ze).ignorePDFAErrors();
                }
            } else if (format.equals("da")) {
                ze = new DXExporterFromA1().setProducer("Mustang-cli").setZUGFeRDVersion(zfIntVersion).setCreator(System.getProperty("user.name")).setProfile(zfConformanceLevelProfile);
                if (ignoreInputErrors.booleanValue()) {
                    ((DXExporterFromA1)ze).ignorePDFAErrors();
                }
            } else {
                if (format.equals("fx")) {
                    zfIntVersion = 2;
                }
                ze = new ZUGFeRDExporterFromPDFA().load(pdfName);
                ze.setProducer("Mustang-cli").setZUGFeRDVersion(zfIntVersion).setCreator(System.getProperty("user.name")).setProfile(zfConformanceLevelProfile);
                if (ignoreInputErrors.booleanValue()) {
                    ((ZUGFeRDExporterFromA1)ze).ignorePDFAErrors();
                }
            }
            for (FileAttachment attachment : attachments) {
                ((ZUGFeRDExporterFromA3)ze).attachFile(attachment.getFilename(), attachment.getData(), attachment.getMimetype(), attachment.getRelation());
            }
            if (format.equals("zf")) {
                ze.disableFacturX();
            }
            ze.setXML(Files.readAllBytes(Paths.get(xmlName, new String[0])));
            ze.export(outName);
            System.out.println("Written to " + outName);
            return;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            System.err.println(e.getMessage());
        }
    }

    private static void performMetrics(String directoryName, Boolean filesFromStdIn, Boolean ignoreFileExt) throws IOException {
        FileChecker fc;
        StatRun sr = new StatRun();
        if (ignoreFileExt.booleanValue()) {
            sr.ignoreFileExtension();
        }
        if (directoryName != null) {
            Path startingDir = Paths.get(directoryName, new String[0]);
            if (Files.isRegularFile(startingDir, new LinkOption[0])) {
                String filename = startingDir.toString();
                fc = new FileChecker(filename, sr);
                fc.checkForZUGFeRD();
                System.out.print(fc.getOutputLine());
            } else if (Files.isDirectory(startingDir, new LinkOption[0])) {
                FileTraverser pf = new FileTraverser(sr);
                Files.walkFileTree(startingDir, pf);
            }
        }
        if (filesFromStdIn.booleanValue()) {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((s = in.readLine()) != null && s.length() != 0) {
                fc = new FileChecker(s, sr);
                fc.checkForZUGFeRD();
                System.out.print(fc.getOutputLine());
            }
        }
        System.out.println(sr.getSummaryLine());
    }

    private static void performVisualization(String sourceName, String lang, String outName, boolean intoPDF) {
        if (sourceName == null) {
            sourceName = Main.getFilenameFromUser("ZUGFeRD XML source", "factur-x.xml", "xml", true, false);
        } else {
            System.out.println("ZUGFeRD XML source set to " + sourceName);
        }
        if (!intoPDF) {
            if (lang == null) {
                try {
                    lang = Main.getStringFromUser("Output language", "en", "en|de|fr");
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            } else {
                System.out.println("Output language set to " + lang);
            }
        }
        if (outName == null) {
            String defaultFilename = "factur-x.html";
            String defaultExtension = "html";
            if (intoPDF) {
                defaultFilename = "factur-x.pdf";
                defaultExtension = "pdf";
            }
            outName = Main.getFilenameFromUser("Target file", defaultFilename, defaultExtension, false, true);
        } else {
            System.out.println("Target set to " + outName);
        }
        try {
            Main.ensureFileExists(sourceName);
            Main.ensureFileNotExists(outName);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        ZUGFeRDVisualizer zvi = new ZUGFeRDVisualizer();
        String xml = null;
        try {
            if (!intoPDF) {
                ZUGFeRDVisualizer.Language langCode = ZUGFeRDVisualizer.Language.EN;
                if (lang.equalsIgnoreCase("de")) {
                    langCode = ZUGFeRDVisualizer.Language.DE;
                }
                if (lang.equalsIgnoreCase("fr")) {
                    langCode = ZUGFeRDVisualizer.Language.FR;
                }
                xml = zvi.visualize(sourceName, langCode);
                Files.write(Paths.get(outName, new String[0]), xml.getBytes(), new OpenOption[0]);
            } else {
                zvi.toPDF(sourceName, outName);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), e);
        }
        catch (TransformerException e) {
            LOGGER.error(e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        System.out.println("Written to " + outName);
        if (!intoPDF) {
            try {
                Main.ExportResource("/xrechnung-viewer.css");
                Main.ExportResource("/xrechnung-viewer.js");
                System.out.println("xrechnung-viewer.css and xrechnung-viewer.js written as well (to local working dir)");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public static String ExportResource(String resourceName) throws Exception {
        String jarFolder;
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            stream = Main.class.getResourceAsStream(resourceName);
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            jarFolder = System.getProperty("user.dir");
            resStreamOut = new FileOutputStream(jarFolder + resourceName);
            while ((readBytes = stream.read(buffer)) > 0) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            stream.close();
            resStreamOut.close();
        }
        return jarFolder + resourceName;
    }

    private static void ensureFileExists(String fileName) throws IOException {
        if (!Main.fileExists(fileName).booleanValue()) {
            throw new IOException(String.format("File %s does not exists", fileName));
        }
    }

    private static void ensureFileNotExists(String fileName) throws IOException {
        if (Main.fileExists(fileName).booleanValue()) {
            throw new IOException(String.format("File %s already exists", fileName));
        }
    }

    private static Boolean fileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        return f.exists();
    }
}

