/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.commandline;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.mustangproject.commandline.FileChecker;
import org.mustangproject.commandline.StatRun;

public class FileTraverser
extends SimpleFileVisitor<Path> {
    private StatRun thisRun;

    public FileTraverser(StatRun statistics) {
        this.thisRun = statistics;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
        if (!attr.isSymbolicLink() && attr.isRegularFile()) {
            String filename = file.toString();
            FileChecker fc = new FileChecker(filename, this.thisRun);
            fc.checkForZUGFeRD();
            System.out.print(fc.getOutputLine());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        this.thisRun.incDirCount();
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        System.err.println(exc);
        return FileVisitResult.CONTINUE;
    }
}

