/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.commandline;

import java.math.BigDecimal;
import org.mustangproject.ZUGFeRD.ZUGFeRDImporter;
import org.mustangproject.commandline.StatRun;

public class FileChecker {
    String filename;
    StatRun thisRun;
    boolean isPDF = false;

    public FileChecker(String filename, StatRun statistics) {
        this.filename = filename;
        this.thisRun = statistics;
        this.thisRun.incFileCount();
        String extension = "";
        if (!this.thisRun.shallIgnoreFileExt()) {
            int extIndex = filename.lastIndexOf(".");
            if (extIndex >= 0) {
                extension = filename.substring(extIndex).toLowerCase();
                this.isPDF = extension.equals(".pdf");
                if (this.isPDF) {
                    this.thisRun.incPDFCount();
                }
            }
        } else {
            this.thisRun.incPDFCount();
        }
    }

    public boolean checkForZUGFeRD() {
        if (!this.isPDF && !this.thisRun.shallIgnoreFileExt()) {
            return false;
        }
        ZUGFeRDImporter zi = new ZUGFeRDImporter(this.filename);
        try {
            if (zi.canParse()) {
                this.thisRun.incZUGFeRDCount(zi.getVersion());
                this.thisRun.incTotal(new BigDecimal(zi.getAmount()));
                return true;
            }
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean isPDF() {
        return this.isPDF;
    }

    public String getOutputLine() {
        return this.thisRun.getOutputLine();
    }
}

