/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.mustangproject.CII.CIIToUBL;
import org.mustangproject.ClasspathResolverURIAdapter;

public class ZUGFeRDVisualizer {
    static final ClassLoader CLASS_LOADER = ZUGFeRDVisualizer.class.getClassLoader();
    private static final String RESOURCE_PATH = "";
    private static final Logger LOG = Logger.getLogger(ZUGFeRDVisualizer.class.getName());
    private TransformerFactory mFactory = new TransformerFactoryImpl();
    private Templates mXsltXRTemplate = null;
    private Templates mXsltUBLTemplate = null;
    private Templates mXsltHTMLTemplate = null;
    private Templates mXsltPDFTemplate = null;
    private Templates mXsltZF1HTMLTemplate = null;

    public ZUGFeRDVisualizer() {
        this.mFactory.setURIResolver(new ClasspathResourceURIResolver());
    }

    public String visualize(String xmlFilename, Language lang) throws FileNotFoundException, TransformerException, UnsupportedEncodingException {
        try {
            if (this.mXsltXRTemplate == null) {
                this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
            }
            if (this.mXsltPDFTemplate == null) {
                this.mXsltPDFTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xr-pdf.xsl")));
            }
            if (this.mXsltHTMLTemplate == null) {
                this.mXsltHTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xrechnung-html." + lang.name().toLowerCase() + ".xsl")));
            }
            if (this.mXsltZF1HTMLTemplate == null) {
                this.mXsltZF1HTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ZUGFeRD_1p0_c1p0_s1p0.xslt")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        FileInputStream fis = new FileInputStream(xmlFilename);
        String fileContent = RESOURCE_PATH;
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(xmlFilename, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            LOG.log(Level.SEVERE, null, e2);
        }
        final ByteArrayOutputStream iaos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String zf1Signature = "rsm:CrossIndustryDocument";
        String zf2Signature = "rsm:CrossIndustryInvoice";
        String ublSignature = "ubl:Invoice";
        String ublCreditNoteSignature = "ubl:CreditNote";
        boolean doPostProcessing = false;
        if (fileContent.contains(zf1Signature)) {
            this.applyZF1XSLT(fis, baos);
        } else if (fileContent.contains(zf2Signature)) {
            this.applyZF2XSLT(fis, iaos);
            doPostProcessing = true;
        } else if (fileContent.contains(ublSignature)) {
            this.applyUBL2XSLT(fis, iaos);
            doPostProcessing = true;
        } else if (fileContent.contains(ublCreditNoteSignature)) {
            this.applyUBLCreditNote2XSLT(fis, iaos);
            doPostProcessing = true;
        }
        if (doPostProcessing) {
            PipedInputStream in = new PipedInputStream();
            try {
                final PipedOutputStream out = new PipedOutputStream(in);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            iaos.writeTo(out);
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, null, e);
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException e) {
                                    LOG.log(Level.SEVERE, null, e);
                                }
                            }
                        }
                    }
                }).start();
                this.applyXSLTToHTML(in, baos);
            }
            catch (IOException e1) {
                LOG.log(Level.SEVERE, null, e1);
            }
        }
        return baos.toString("UTF-8");
    }

    protected String toFOP(String xmlFilename) throws FileNotFoundException, TransformerException, UnsupportedEncodingException {
        try {
            if (this.mXsltXRTemplate == null) {
                this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
            }
            if (this.mXsltPDFTemplate == null) {
                this.mXsltPDFTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xr-pdf.xsl")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        FileInputStream fis = new FileInputStream(xmlFilename);
        String fileContent = RESOURCE_PATH;
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(xmlFilename, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            LOG.log(Level.SEVERE, null, e2);
        }
        final ByteArrayOutputStream iaos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.applyZF2XSLT(fis, iaos);
        PipedInputStream in = new PipedInputStream();
        try {
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        iaos.writeTo(out);
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, null, e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                LOG.log(Level.SEVERE, null, e);
                            }
                        }
                    }
                }
            }).start();
            this.applyXSLTToPDF(in, baos);
        }
        catch (IOException e1) {
            LOG.log(Level.SEVERE, null, e1);
        }
        return baos.toString("UTF-8");
    }

    public void toPDF(String xmlFilename, String pdfFilename) {
        CIIToUBL c2u = new CIIToUBL();
        String sourceFilename = "factur-x.xml";
        File CIIinputFile = new File(xmlFilename);
        Object expected = null;
        String result = null;
        ZUGFeRDVisualizer zvi = new ZUGFeRDVisualizer();
        try {
            result = zvi.toFOP(CIIinputFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(ZUGFeRDVisualizer.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (TransformerException e) {
            Logger.getLogger(ZUGFeRDVisualizer.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ZUGFeRDVisualizer.class.getName()).log(Level.SEVERE, null, e);
        }
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        DefaultConfiguration cfg = null;
        try {
            cfg = cfgBuilder.build(CLASS_LOADER.getResourceAsStream("fop-config.xconf"));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        FopFactoryBuilder builder = new FopFactoryBuilder(new File(".").toURI(), new ClasspathResolverURIAdapter()).setConfiguration(cfg);
        FopFactory fopFactory = builder.build();
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.getRendererOptions().put("pdf-a-mode", "PDF/A-1b");
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdfFilename));){
            Fop fop = fopFactory.newFop("application/pdf", userAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8)));
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FOPException e) {
            Logger.getLogger(ZUGFeRDVisualizer.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (TransformerConfigurationException e) {
            Logger.getLogger(ZUGFeRDVisualizer.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (IOException e) {
            Logger.getLogger(ZUGFeRDVisualizer.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (TransformerException e) {
            Logger.getLogger(ZUGFeRDVisualizer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    protected void applyZF2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltXRTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyUBL2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-invoice-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyUBLCreditNote2XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-creditnote-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyZF1XSLT(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltZF1HTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyXSLTToHTML(InputStream xmlFile, OutputStream HTMLOutstream) throws TransformerException {
        Transformer transformer = this.mXsltHTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(HTMLOutstream));
    }

    protected void applyXSLTToPDF(InputStream xmlFile, OutputStream PDFOutstream) throws TransformerException {
        Transformer transformer = this.mXsltPDFTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(PDFOutstream));
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/" + href));
        }
    }

    public static enum Language {
        EN,
        FR,
        DE;

    }
}

