/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IExporter;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDExporter;
import org.mustangproject.ZUGFeRD.PDFAConformanceLevel;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromA1;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromA3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZUGFeRDExporterFromPDFA
implements IZUGFeRDExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDExporterFromPDFA.class.getCanonicalName());
    protected IZUGFeRDExporter theExporter;

    protected void determineAndSetExporter(int PDFAVersion) {
        if (PDFAVersion == 3) {
            this.theExporter = new ZUGFeRDExporterFromA3();
        } else if (PDFAVersion == 1) {
            this.theExporter = new ZUGFeRDExporterFromA1();
        } else {
            throw new IllegalArgumentException("PDF-A version not supported");
        }
    }

    protected IZUGFeRDExporter getExporter() {
        if (this.theExporter == null) {
            throw new RuntimeException("In ZUGFeRDExporterFromPDFA, source must always be loaded before other operations are performed.");
        }
        return this.theExporter;
    }

    protected byte[] filenameToByteArray(String pdfFilename) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(pdfFilename);
        return this.inputstreamToByteArray(fileInputStream);
    }

    protected byte[] inputstreamToByteArray(InputStream fileInputStream) throws IOException {
        byte[] bytes = new byte[fileInputStream.available()];
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        dataInputStream.readFully(bytes);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPDFAVersion(byte[] byteArrayInputStream) throws IOException {
        PDDocument document = PDDocument.load(byteArrayInputStream);
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDMetadata metadata = catalog.getMetadata();
        if (metadata != null) {
            try {
                DomXmpParser xmpParser = new DomXmpParser();
                XMPMetadata xmp = xmpParser.parse(metadata.createInputStream());
                PDFAIdentificationSchema pdfaSchema = xmp.getPDFIdentificationSchema();
                if (pdfaSchema != null) {
                    int n = pdfaSchema.getPart();
                    return n;
                }
            }
            catch (XmpParsingException e) {
                LOGGER.error("XmpParsingException", e);
            }
            finally {
                document.close();
            }
        }
        return 0;
    }

    @Override
    public IZUGFeRDExporter load(String pdfFilename) throws IOException {
        this.determineAndSetExporter(this.getPDFAVersion(this.filenameToByteArray(pdfFilename)));
        return this.theExporter.load(pdfFilename);
    }

    @Override
    public IZUGFeRDExporter load(byte[] pdfBinary) throws IOException {
        this.determineAndSetExporter(this.getPDFAVersion(pdfBinary));
        return this.theExporter.load(pdfBinary);
    }

    @Override
    public IZUGFeRDExporter load(InputStream pdfSource) throws IOException {
        byte[] byteArray = this.inputstreamToByteArray(pdfSource);
        this.determineAndSetExporter(this.getPDFAVersion(byteArray));
        return this.theExporter.load(byteArray);
    }

    @Override
    public IZUGFeRDExporter setCreator(String creator) {
        return this.getExporter().setCreator(creator);
    }

    @Override
    public ZUGFeRDExporterFromPDFA setProfile(Profile p) {
        return (ZUGFeRDExporterFromPDFA)this.getExporter().setProfile(p);
    }

    public ZUGFeRDExporterFromPDFA setProfile(String profileName) {
        Profile p = Profiles.getByName(profileName);
        if (p == null) {
            throw new RuntimeException("Profile not found.");
        }
        return (ZUGFeRDExporterFromPDFA)this.getExporter().setProfile(p);
    }

    @Override
    public IZUGFeRDExporter setConformanceLevel(PDFAConformanceLevel newLevel) {
        return this.getExporter().setConformanceLevel(newLevel);
    }

    @Override
    public IZUGFeRDExporter setProducer(String producer) {
        return this.getExporter().setProducer(producer);
    }

    @Override
    public IZUGFeRDExporter setZUGFeRDVersion(int version) {
        return this.getExporter().setZUGFeRDVersion(version);
    }

    @Override
    public boolean ensurePDFIsValid(DataSource dataSource) throws IOException {
        return this.getExporter().ensurePDFIsValid(dataSource);
    }

    @Override
    public IZUGFeRDExporter setXML(byte[] zugferdData) throws IOException {
        return this.getExporter().setXML(zugferdData);
    }

    @Override
    public IZUGFeRDExporter disableFacturX() {
        return this.getExporter().disableFacturX();
    }

    @Override
    public String getNamespaceForVersion(int ver) {
        return this.getExporter().getNamespaceForVersion(ver);
    }

    @Override
    public String getPrefixForVersion(int ver) {
        return this.getExporter().getPrefixForVersion(ver);
    }

    @Override
    public IZUGFeRDExporter disableAutoClose(boolean disableAutoClose) {
        return this.getExporter().disableAutoClose(disableAutoClose);
    }

    @Override
    public IXMLProvider getProvider() {
        return this.getExporter().getProvider();
    }

    @Override
    public void close() throws IOException {
        this.getExporter().close();
    }

    @Override
    public IExporter setTransaction(IExportableTransaction trans) throws IOException {
        return this.getExporter().setTransaction(trans);
    }

    @Override
    public void export(String ZUGFeRDfilename) throws IOException {
        this.getExporter().export(ZUGFeRDfilename);
    }

    @Override
    public void export(OutputStream output) throws IOException {
        this.getExporter().export(output);
    }
}

