/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mustangproject.EStandard;
import org.mustangproject.FileAttachment;
import org.mustangproject.Invoice;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.OXPullProvider;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;

public class DAPullProvider
extends ZUGFeRD2PullProvider
implements IXMLProvider {
    protected IExportableTransaction trans;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName(EStandard.despatchadvice, "pilot", 1);

    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        String typecode = "220";
        String testBooleanStr = "true";
        String xml = "<SCRDMCCBDACIDAMessageStructure\n        xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:25\"\n        xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:101\"\n        xmlns:px=\"urn:un:unece:uncefact:data:standard:SCRDMCCBDACIDAMessageStructure:1\">\n<px:ExchangedDocumentContext> <ram:TestIndicator><udt:Indicator>" + testBooleanStr + "</udt:Indicator></ram:TestIndicator>\n<ram:BusinessProcessSpecifiedDocumentContextParameter><ram:ID>" + this.getProfile().getID() + "</ram:ID></ram:BusinessProcessSpecifiedDocumentContextParameter></px:ExchangedDocumentContext><px:ExchangedDocument><ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID><ram:TypeCode>" + "220" + "</ram:TypeCode><ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>" + this.buildNotes(trans) + "</px:ExchangedDocument><px:SupplyChainTradeTransaction>";
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : trans.getZFItems()) {
            ++lineID;
            if (currentItem.getProduct().getTaxExemptionReason() != null) {
                // empty if block
            }
            LineCalculator lc = new LineCalculator(currentItem);
            xml = xml + "<ram:IncludedSupplyChainTradeLineItem><ram:AssociatedDocumentLineDocument><ram:LineID>" + lineID + "</ram:LineID>" + this.buildItemNotes(currentItem) + "</ram:AssociatedDocumentLineDocument><ram:SpecifiedTradeProduct>";
            if (currentItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "<ram:SellerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>";
            }
            if (currentItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "<ram:BuyerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>";
            }
            String allowanceChargeStr = "";
            if (currentItem.getItemAllowances() != null && currentItem.getItemAllowances().length > 0) {
                for (IZUGFeRDAllowanceCharge allowance : currentItem.getItemAllowances()) {
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(allowance, currentItem);
                }
            }
            if (currentItem.getItemCharges() != null && currentItem.getItemCharges().length > 0) {
                for (IZUGFeRDAllowanceCharge charge : currentItem.getItemCharges()) {
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(charge, currentItem);
                }
            }
            xml = xml + "<ram:Name>" + XMLTools.encodeXML(currentItem.getProduct().getName()) + "</ram:Name><ram:Description>" + XMLTools.encodeXML(currentItem.getProduct().getDescription()) + "</ram:Description></ram:SpecifiedTradeProduct><ram:SpecifiedLineTradeDelivery><ram:DespatchedQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getQuantity()) + "</ram:DespatchedQuantity></ram:SpecifiedLineTradeDelivery><ram:SpecifiedLineTradeSettlement>";
            if (currentItem.getDetailedDeliveryPeriodFrom() != null || currentItem.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:BillingSpecifiedPeriod>";
                if (currentItem.getDetailedDeliveryPeriodFrom() != null) {
                    xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
                }
                if (currentItem.getDetailedDeliveryPeriodTo() != null) {
                    xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
                }
                xml = xml + "</ram:BillingSpecifiedPeriod>";
            }
            xml = xml + "<ram:SpecifiedTradeSettlementLineMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(lc.getItemTotalNetAmount()) + "</ram:LineTotalAmount></ram:SpecifiedTradeSettlementLineMonetarySummation>";
            xml = xml + "</ram:SpecifiedLineTradeSettlement></ram:IncludedSupplyChainTradeLineItem>";
        }
        xml = xml + "<ram:ApplicableHeaderTradeAgreement>";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>";
        }
        xml = xml + "<ram:SellerTradeParty>" + this.getTradePartyAsXML(trans.getSender(), true, false) + "</ram:SellerTradeParty><ram:BuyerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        xml = xml + "</ram:BuyerTradeParty>";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:SellerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:SellerOrderReferencedDocument>";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:BuyerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:BuyerOrderReferencedDocument>";
        }
        if (trans.getContractReferencedDocument() != null) {
            xml = xml + "<ram:ContractReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getContractReferencedDocument()) + "</ram:IssuerAssignedID></ram:ContractReferencedDocument>";
        }
        if (trans.getAdditionalReferencedDocuments() != null) {
            for (FileAttachment f : trans.getAdditionalReferencedDocuments()) {
                String documentContent = new String(Base64.getEncoder().encodeToString(f.getData()));
                xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + f.getFilename() + "</ram:IssuerAssignedID><ram:TypeCode>916</ram:TypeCode><ram:Name>" + f.getDescription() + "</ram:Name><ram:AttachmentBinaryObject mimeCode=\"" + f.getMimetype() + "\"\nfilename=\"" + f.getFilename() + "\">" + documentContent + "</ram:AttachmentBinaryObject></ram:AdditionalReferencedDocument>";
            }
        }
        if (trans.getSpecifiedProcuringProjectID() != null) {
            xml = xml + "<ram:SpecifiedProcuringProject><ram:ID>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectID()) + "</ram:ID>";
            if (trans.getSpecifiedProcuringProjectName() != null) {
                xml = xml + "<ram:Name >" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectName()) + "</ram:Name>";
            }
            xml = xml + "</ram:SpecifiedProcuringProject>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeAgreement><ram:ApplicableHeaderTradeDelivery>";
        if (this.trans.getDeliveryAddress() != null) {
            xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(this.trans.getDeliveryAddress(), false, true) + "</ram:ShipToTradeParty>";
        }
        xml = xml + " <ram:ActualDespatchSupplyChainEvent>\n                <ram:OccurrenceDateTime>\n                    <udt:DateTimeString\n                            format=\"102\">" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDeliveryDate()) + "</udt:DateTimeString>\n                </ram:OccurrenceDateTime>\n            </ram:ActualDespatchSupplyChainEvent>";
        xml = xml + "</ram:ApplicableHeaderTradeDelivery>\n";
        xml = xml + "</px:SupplyChainTradeTransaction></SCRDMCCBDACIDAMessageStructure>";
        try {
            byte[] zugferdRaw = xml.getBytes("UTF-8");
            this.zugferdData = XMLTools.removeBOM(zugferdRaw);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(OXPullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    protected String buildNotes(IExportableTransaction exportableTransaction) {
        Invoice copyWithoutRebateInfo = new Invoice().setOwnOrganisationFullPlaintextInfo(exportableTransaction.getOwnOrganisationFullPlaintextInfo()).addNotes(exportableTransaction.getNotesWithSubjectCode());
        if (exportableTransaction.getNotes() != null) {
            for (String note : exportableTransaction.getNotes()) {
                copyWithoutRebateInfo.addNote(note);
            }
        }
        Optional.ofNullable(exportableTransaction.getSubjectNote()).ifPresent(copyWithoutRebateInfo::addNote);
        return super.buildNotes(copyWithoutRebateInfo);
    }
}

