/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTools
extends XMLWriter {
    @Override
    public String escapeAttributeEntities(String s) {
        return super.escapeAttributeEntities(s);
    }

    @Override
    public String escapeElementEntities(String s) {
        return super.escapeElementEntities(s);
    }

    public static List<Node> asList(NodeList n) {
        return n.getLength() == 0 ? Collections.emptyList() : new NodeListWrapper(n);
    }

    public static String nDigitFormat(BigDecimal value, int scale) {
        return value.setScale(scale, RoundingMode.HALF_UP).toPlainString();
    }

    public static String encodeXML(CharSequence s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c >= 55296 && c <= 56319 && i + 1 < len) {
                c = c - 55232 << 10 | s.charAt(++i) & 0x3FF;
            }
            if (c < 128) {
                if (c < 32 && c != 9 && c != 13 && c != 10) {
                    sb.append("&#xfffd;");
                    continue;
                }
                switch (c) {
                    case 38: {
                        sb.append("&amp;");
                        break;
                    }
                    case 62: {
                        sb.append("&gt;");
                        break;
                    }
                    case 60: {
                        sb.append("&lt;");
                        break;
                    }
                    default: {
                        sb.append((char)c);
                        break;
                    }
                }
                continue;
            }
            if (c >= 55296 && c <= 57343 || c == 65534 || c == 65535) {
                sb.append("&#xfffd;");
                continue;
            }
            sb.append("&#x");
            sb.append(Integer.toHexString(c));
            sb.append(';');
        }
        return sb.toString();
    }

    public static byte[] removeBOM(byte[] zugferdRaw) {
        byte[] zugferdData;
        if (zugferdRaw[0] == -17 && zugferdRaw[1] == -69 && zugferdRaw[2] == -65) {
            zugferdData = new byte[zugferdRaw.length - 3];
            System.arraycopy(zugferdRaw, 3, zugferdData, 0, zugferdRaw.length - 3);
        } else {
            zugferdData = zugferdRaw;
        }
        return zugferdData;
    }

    public static byte[] getBytesFromStream(InputStream fileinput) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        BufferedInputStream bufferedInput = new BufferedInputStream(fileinput);
        while ((nRead = bufferedInput.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    static final class NodeListWrapper
    extends AbstractList<Node>
    implements RandomAccess {
        private final NodeList list;

        NodeListWrapper(NodeList l) {
            this.list = l;
        }

        @Override
        public Node get(int index) {
            return this.list.item(index);
        }

        @Override
        public int size() {
            return this.list.getLength();
        }
    }
}

