/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import org.mustangproject.SchemedID;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableProduct;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Product
implements IZUGFeRDExportableProduct {
    protected String unit;
    protected String name;
    protected String description;
    protected String sellerAssignedID;
    protected String buyerAssignedID;
    protected BigDecimal VATPercent;
    protected boolean isReverseCharge = false;
    protected boolean isIntraCommunitySupply = false;
    protected SchemedID globalId = null;

    public Product(String name, String description, String unit, BigDecimal VATPercent) {
        this.unit = unit;
        this.name = name;
        this.description = description;
        this.VATPercent = VATPercent;
    }

    public Product() {
    }

    @Override
    public String getGlobalID() {
        if (this.globalId == null) {
            return null;
        }
        return this.globalId.getID();
    }

    @Override
    public String getGlobalIDScheme() {
        if (this.globalId == null) {
            return null;
        }
        return this.globalId.getScheme();
    }

    public Product addGlobalID(SchemedID schemedID) {
        this.globalId = schemedID;
        return this;
    }

    @Override
    public String getSellerAssignedID() {
        return this.sellerAssignedID;
    }

    public Product setSellerAssignedID(String sellerAssignedID) {
        this.sellerAssignedID = sellerAssignedID;
        return this;
    }

    @Override
    public String getBuyerAssignedID() {
        return this.buyerAssignedID;
    }

    public Product setBuyerAssignedID(String buyerAssignedID) {
        this.buyerAssignedID = buyerAssignedID;
        return this;
    }

    @Override
    public boolean isReverseCharge() {
        return this.isReverseCharge;
    }

    @Override
    public boolean isIntraCommunitySupply() {
        return this.isIntraCommunitySupply;
    }

    public Product setReverseCharge() {
        this.isReverseCharge = true;
        this.setVATPercent(BigDecimal.ZERO);
        return this;
    }

    public Product setIntraCommunitySupply() {
        this.isIntraCommunitySupply = true;
        this.setVATPercent(BigDecimal.ZERO);
        return this;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public Product setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Product setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Product setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public BigDecimal getVATPercent() {
        return this.VATPercent;
    }

    public Product setVATPercent(BigDecimal VATPercent) {
        this.VATPercent = VATPercent;
        return this;
    }
}

