/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import org.mustangproject.Product;
import org.mustangproject.ReferencedDocument;
import org.mustangproject.SchemedID;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IReferencedDocument;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Item
implements IZUGFeRDExportableItem {
    protected BigDecimal price;
    protected BigDecimal quantity;
    protected BigDecimal tax;
    protected BigDecimal grossPrice;
    protected BigDecimal lineTotalAmount;
    protected BigDecimal basisQuantity = BigDecimal.ONE;
    protected Date detailedDeliveryPeriodFrom = null;
    protected Date detailedDeliveryPeriodTo = null;
    protected String id;
    protected String referencedLineID = null;
    protected Product product;
    protected ArrayList<String> notes = null;
    protected ArrayList<ReferencedDocument> referencedDocuments = null;
    protected ArrayList<IZUGFeRDAllowanceCharge> Allowances = new ArrayList();
    protected ArrayList<IZUGFeRDAllowanceCharge> Charges = new ArrayList();

    public Item(Product product, BigDecimal price, BigDecimal quantity) {
        this.price = price;
        this.quantity = quantity;
        this.product = product;
    }

    public Item() {
    }

    public Item(NodeList itemChilds, boolean recalcPrice) {
        String price = "0";
        String basisQuantity = "1";
        String name = "";
        String sellerAssignedID = null;
        String description = "";
        SchemedID gid = null;
        String quantity = "0";
        String vatPercent = null;
        String lineTotal = "0";
        String unitCode = "0";
        ArrayList<ReferencedDocument> rdocs = null;
        for (int itemChildIndex = 0; itemChildIndex < itemChilds.getLength(); ++itemChildIndex) {
            NodeList tradeLineChilds;
            String lineTrade = itemChilds.item(itemChildIndex).getLocalName();
            if (lineTrade != null && lineTrade.equals("Item")) {
                NodeList UBLitemChilds = itemChilds.item(itemChildIndex).getChildNodes();
                for (Node currentUBLItemChildNode : XMLTools.asList(UBLitemChilds)) {
                    if (currentUBLItemChildNode.getLocalName() != null && currentUBLItemChildNode.getLocalName().equals("Name")) {
                        name = currentUBLItemChildNode.getTextContent();
                    }
                    if (currentUBLItemChildNode.getLocalName() == null || !currentUBLItemChildNode.getLocalName().equals("ClassifiedTaxCategory")) continue;
                    for (Node currentUBLTaxChildNode : XMLTools.asList(currentUBLItemChildNode.getChildNodes())) {
                        if (currentUBLTaxChildNode.getLocalName() == null || !currentUBLTaxChildNode.getLocalName().equals("Percent")) continue;
                        vatPercent = currentUBLTaxChildNode.getTextContent();
                    }
                }
            }
            if (lineTrade != null && lineTrade.equals("Price")) {
                NodeList UBLpriceChilds = itemChilds.item(itemChildIndex).getChildNodes();
                for (Node currentUBLPriceChildNode : XMLTools.asList(UBLpriceChilds)) {
                    if (currentUBLPriceChildNode.getLocalName() != null && currentUBLPriceChildNode.getLocalName().equals("PriceAmount")) {
                        price = currentUBLPriceChildNode.getTextContent();
                    }
                    if (currentUBLPriceChildNode.getLocalName() == null || !currentUBLPriceChildNode.getLocalName().equals("BaseQuantity")) continue;
                    basisQuantity = currentUBLPriceChildNode.getTextContent();
                }
            }
            if (lineTrade != null && lineTrade.equals("InvoicedQuantity")) {
                quantity = itemChilds.item(itemChildIndex).getTextContent();
                unitCode = itemChilds.item(itemChildIndex).getAttributes().getNamedItem("unitCode").getNodeValue();
            }
            if (lineTrade != null && (lineTrade.equals("SpecifiedLineTradeAgreement") || lineTrade.equals("SpecifiedSupplyChainTradeAgreement"))) {
                tradeLineChilds = itemChilds.item(itemChildIndex).getChildNodes();
                for (int tradeLineChildIndex = 0; tradeLineChildIndex < tradeLineChilds.getLength(); ++tradeLineChildIndex) {
                    if (tradeLineChilds.item(tradeLineChildIndex).getLocalName() != null && tradeLineChilds.item(tradeLineChildIndex).getLocalName().equals("AdditionalReferencedDocument")) {
                        String IssuerAssignedID = "";
                        String TypeCode = "";
                        String ReferenceTypeCode = "";
                        NodeList refDocChilds = tradeLineChilds.item(tradeLineChildIndex).getChildNodes();
                        for (int refDocIndex = 0; refDocIndex < refDocChilds.getLength(); ++refDocIndex) {
                            String localName = refDocChilds.item(refDocIndex).getLocalName();
                            if (localName != null && localName.equals("IssuerAssignedID")) {
                                IssuerAssignedID = refDocChilds.item(refDocIndex).getTextContent();
                            }
                            if (localName != null && localName.equals("TypeCode")) {
                                TypeCode = refDocChilds.item(refDocIndex).getTextContent();
                            }
                            if (localName == null || !localName.equals("ReferenceTypeCode")) continue;
                            ReferenceTypeCode = refDocChilds.item(refDocIndex).getTextContent();
                        }
                        ReferencedDocument rd = new ReferencedDocument(IssuerAssignedID, TypeCode, ReferenceTypeCode);
                        if (rdocs == null) {
                            rdocs = new ArrayList<ReferencedDocument>();
                        }
                        rdocs.add(rd);
                    }
                    if (tradeLineChilds.item(tradeLineChildIndex).getLocalName() == null || !tradeLineChilds.item(tradeLineChildIndex).getLocalName().equals("NetPriceProductTradePrice")) continue;
                    NodeList netChilds = tradeLineChilds.item(tradeLineChildIndex).getChildNodes();
                    for (int netIndex = 0; netIndex < netChilds.getLength(); ++netIndex) {
                        if (netChilds.item(netIndex).getLocalName() != null && netChilds.item(netIndex).getLocalName().equals("ChargeAmount")) {
                            price = netChilds.item(netIndex).getTextContent();
                        }
                        if (netChilds.item(netIndex).getLocalName() == null || !netChilds.item(netIndex).getLocalName().equals("BasisQuantity") && !netChilds.item(netIndex).getLocalName().equals("InvoicedQuantity")) continue;
                        basisQuantity = netChilds.item(netIndex).getTextContent();
                    }
                }
            }
            if (lineTrade != null && (lineTrade.equals("SpecifiedLineTradeDelivery") || lineTrade.equals("SpecifiedSupplyChainTradeDelivery"))) {
                tradeLineChilds = itemChilds.item(itemChildIndex).getChildNodes();
                for (int tradeLineChildIndex = 0; tradeLineChildIndex < tradeLineChilds.getLength(); ++tradeLineChildIndex) {
                    String tradeName = tradeLineChilds.item(tradeLineChildIndex).getLocalName();
                    if (tradeName == null || !tradeName.equals("BilledQuantity") && !tradeName.equals("RequestedQuantity") && !tradeName.equals("DespatchedQuantity")) continue;
                    quantity = tradeLineChilds.item(tradeLineChildIndex).getTextContent();
                    unitCode = tradeLineChilds.item(tradeLineChildIndex).getAttributes().getNamedItem("unitCode").getNodeValue();
                }
            }
            if (lineTrade != null && lineTrade.equals("SpecifiedTradeProduct")) {
                NodeList tradeProductChilds = itemChilds.item(itemChildIndex).getChildNodes();
                for (int tradeProductChildIndex = 0; tradeProductChildIndex < tradeProductChilds.getLength(); ++tradeProductChildIndex) {
                    if (tradeProductChilds.item(tradeProductChildIndex).getLocalName() != null && tradeProductChilds.item(tradeProductChildIndex).getLocalName().equals("Name")) {
                        name = tradeProductChilds.item(tradeProductChildIndex).getTextContent();
                    }
                    if (tradeProductChilds.item(tradeProductChildIndex).getLocalName() != null && tradeProductChilds.item(tradeProductChildIndex).getLocalName().equals("SellerAssignedID")) {
                        sellerAssignedID = tradeProductChilds.item(tradeProductChildIndex).getTextContent();
                    }
                    if (tradeProductChilds.item(tradeProductChildIndex).getLocalName() == null || !tradeProductChilds.item(tradeProductChildIndex).getLocalName().equals("GlobalID") || tradeProductChilds.item(tradeProductChildIndex).getAttributes().getNamedItem("schemeID") == null) continue;
                    gid = new SchemedID().setScheme(tradeProductChilds.item(tradeProductChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue()).setId(tradeProductChilds.item(tradeProductChildIndex).getTextContent());
                }
            }
            if (lineTrade == null || !lineTrade.equals("SpecifiedLineTradeSettlement") && !lineTrade.equals("SpecifiedSupplyChainTradeSettlement")) continue;
            NodeList tradeSettlementChilds = itemChilds.item(itemChildIndex).getChildNodes();
            for (int tradeSettlementChildIndex = 0; tradeSettlementChildIndex < tradeSettlementChilds.getLength(); ++tradeSettlementChildIndex) {
                String tradeSettlementName = tradeSettlementChilds.item(tradeSettlementChildIndex).getLocalName();
                if (tradeSettlementName == null) continue;
                if (tradeSettlementName.equals("ApplicableTradeTax")) {
                    NodeList taxChilds = tradeSettlementChilds.item(tradeSettlementChildIndex).getChildNodes();
                    for (int taxChildIndex = 0; taxChildIndex < taxChilds.getLength(); ++taxChildIndex) {
                        String taxChildName = taxChilds.item(taxChildIndex).getLocalName();
                        if (taxChildName == null || !taxChildName.equals("RateApplicablePercent") && !taxChildName.equals("ApplicablePercent")) continue;
                        vatPercent = taxChilds.item(taxChildIndex).getTextContent();
                    }
                }
                if (!tradeSettlementName.equals("SpecifiedTradeSettlementLineMonetarySummation")) continue;
                NodeList totalChilds = tradeSettlementChilds.item(tradeSettlementChildIndex).getChildNodes();
                for (int totalChildIndex = 0; totalChildIndex < totalChilds.getLength(); ++totalChildIndex) {
                    if (totalChilds.item(totalChildIndex).getLocalName() == null || !totalChilds.item(totalChildIndex).getLocalName().equals("LineTotalAmount")) continue;
                    lineTotal = totalChilds.item(totalChildIndex).getTextContent();
                }
            }
        }
        BigDecimal prc = new BigDecimal(price.trim());
        BigDecimal qty = new BigDecimal(quantity.trim());
        if (recalcPrice && !qty.equals(BigDecimal.ZERO)) {
            prc = new BigDecimal(lineTotal.trim()).divide(qty, 4, RoundingMode.HALF_UP);
        }
        Product p = new Product(name, description, unitCode, vatPercent == null ? null : new BigDecimal(vatPercent.trim()));
        if (gid != null) {
            p.addGlobalID(gid);
        }
        if (sellerAssignedID != null) {
            p.setSellerAssignedID(sellerAssignedID);
        }
        this.setProduct(p);
        this.setPrice(prc);
        this.setQuantity(qty);
        this.setBasisQuantity(new BigDecimal(basisQuantity));
        if (rdocs != null) {
            for (ReferencedDocument rdoc : rdocs) {
                this.addReferencedDocument(rdoc);
            }
        }
    }

    public Item addReferencedLineID(String s) {
        this.referencedLineID = s;
        return this;
    }

    @Override
    public String getBuyerOrderReferencedDocumentLineID() {
        return this.referencedLineID;
    }

    public BigDecimal getLineTotalAmount() {
        return this.lineTotalAmount;
    }

    public Item setLineTotalAmount(BigDecimal lineTotalAmount) {
        this.lineTotalAmount = lineTotalAmount;
        return this;
    }

    public BigDecimal getGrossPrice() {
        return this.grossPrice;
    }

    public Item setGrossPrice(BigDecimal grossPrice) {
        this.grossPrice = grossPrice;
        return this;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public Item setTax(BigDecimal tax) {
        this.tax = tax;
        return this;
    }

    public Item setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public Item setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    @Override
    public BigDecimal getBasisQuantity() {
        return this.basisQuantity;
    }

    public Item setBasisQuantity(BigDecimal basis) {
        this.basisQuantity = basis;
        return this;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public Item setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getItemAllowances() {
        if (this.Allowances.isEmpty()) {
            return null;
        }
        return this.Allowances.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getItemCharges() {
        if (this.Charges.isEmpty()) {
            return null;
        }
        return this.Charges.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    @Override
    public String[] getNotes() {
        if (this.notes == null) {
            return null;
        }
        return this.notes.toArray(new String[0]);
    }

    public Item setProduct(Product product) {
        this.product = product;
        return this;
    }

    public Item addCharge(IZUGFeRDAllowanceCharge izac) {
        this.Charges.add(izac);
        return this;
    }

    public Item addAllowance(IZUGFeRDAllowanceCharge izac) {
        this.Allowances.add(izac);
        return this;
    }

    public Item addNote(String text) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(text);
        return this;
    }

    public Item addReferencedDocument(ReferencedDocument doc) {
        if (this.referencedDocuments == null) {
            this.referencedDocuments = new ArrayList();
        }
        this.referencedDocuments.add(doc);
        return this;
    }

    @Override
    public IReferencedDocument[] getReferencedDocuments() {
        if (this.referencedDocuments == null) {
            return null;
        }
        return this.referencedDocuments.toArray(new IReferencedDocument[0]);
    }

    public Item setDetailedDeliveryPeriod(Date from, Date to) {
        this.detailedDeliveryPeriodFrom = from;
        this.detailedDeliveryPeriodTo = to;
        return this;
    }

    @Override
    public Date getDetailedDeliveryPeriodFrom() {
        return this.detailedDeliveryPeriodFrom;
    }

    @Override
    public Date getDetailedDeliveryPeriodTo() {
        return this.detailedDeliveryPeriodTo;
    }
}

