/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import java.math.BigDecimal;
import org.mustangproject.ZUGFeRD.IAbsoluteValueProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;

public class Charge
implements IZUGFeRDAllowanceCharge {
    protected BigDecimal percent = null;
    protected BigDecimal totalAmount;
    protected BigDecimal taxPercent;
    protected String reason;
    protected String categoryCode;

    public Charge() {
        this.taxPercent = BigDecimal.ZERO;
    }

    public Charge(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Charge setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public Charge setPercent(BigDecimal percent) {
        this.percent = percent;
        return this;
    }

    public Charge setTaxPercent(BigDecimal taxPercent) {
        this.taxPercent = taxPercent;
        return this;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public Charge setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public BigDecimal getTotalAmount(IAbsoluteValueProvider currentItem) {
        if (this.totalAmount != null) {
            return this.totalAmount;
        }
        if (this.percent != null) {
            return currentItem.getValue().multiply(this.getPercent().divide(new BigDecimal(100)));
        }
        throw new RuntimeException("Either totalAmount or percent must be set");
    }

    @Override
    public BigDecimal getPercent() {
        return this.percent;
    }

    @Override
    public BigDecimal getTaxPercent() {
        return this.taxPercent;
    }

    @Override
    public boolean isCharge() {
        return true;
    }

    @Override
    public String getCategoryCode() {
        if (this.categoryCode != null) {
            return this.categoryCode;
        }
        return IZUGFeRDAllowanceCharge.super.getCategoryCode();
    }

    public Charge setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
        return this;
    }
}

