/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.data.Percentage;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldBeEqualWithinPercentage
extends BasicErrorMessageFactory {
    public static <T extends Number> ErrorMessageFactory shouldBeEqualWithinPercentage(T actual, T expected, Percentage percentage, T difference) {
        double expectedPercentage = difference.doubleValue() / expected.doubleValue() * 100.0;
        return new ShouldBeEqualWithinPercentage(actual, expected, percentage, expectedPercentage);
    }

    private <T extends Number> ShouldBeEqualWithinPercentage(Number actual, Number expected, Percentage percentage, double expectedPercentage) {
        super("%nExpecting:%n  <%s>%nto be close to:%n  <%s>%nby less than %s but difference was %s%%.%n(a difference of exactly %s being considered valid)", actual, expected, percentage, expectedPercentage, percentage);
    }
}

