/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ConstructorInvoker {
    ConstructorInvoker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object newInstance(String className, Class<?>[] parameterTypes, Object ... parameterValues) throws Exception {
        Class<?> targetType = Class.forName(className);
        Constructor<?> constructor = targetType.getConstructor(parameterTypes);
        boolean accessible = constructor.isAccessible();
        try {
            this.setAccessible(constructor, true);
            Object obj = constructor.newInstance(parameterValues);
            return obj;
        }
        finally {
            try {
                this.setAccessible(constructor, accessible);
            }
            catch (RuntimeException e) {}
        }
    }

    private void setAccessible(AccessibleObject accessible, boolean value) {
        AccessController.doPrivileged(new SetAccessibleValueAction(accessible, value));
    }

    private static class SetAccessibleValueAction
    implements PrivilegedAction<Void> {
        private final AccessibleObject accessible;
        private final boolean value;

        private SetAccessibleValueAction(AccessibleObject accessible, boolean value) {
            this.accessible = accessible;
            this.value = value;
        }

        @Override
        public Void run() {
            this.accessible.setAccessible(this.value);
            return null;
        }
    }
}

