/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.filter.FilterOperator;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.data.Index;
import org.assertj.core.description.Description;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ExtendedByTypesComparator;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.ObjectArrayElementComparisonStrategy;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.internal.RecursiveFieldByFieldComparator;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractObjectArrayAssert<SELF extends AbstractObjectArrayAssert<SELF, ELEMENT>, ELEMENT>
extends AbstractAssert<SELF, ELEMENT[]>
implements IndexedObjectEnumerableAssert<AbstractObjectArrayAssert<SELF, ELEMENT>, ELEMENT>,
ArraySortedAssert<AbstractObjectArrayAssert<SELF, ELEMENT>, ELEMENT> {
    @VisibleForTesting
    ObjectArrays arrays = ObjectArrays.instance();
    private TypeComparators comparatorsByType = TypeComparators.defaultTypeComparators();
    private Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames = new TreeMap();
    private TypeComparators comparatorsForElementPropertyOrFieldTypes = TypeComparators.defaultTypeComparators();

    public AbstractObjectArrayAssert(ELEMENT[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public SELF as(Description description) {
        return (SELF)((AbstractObjectArrayAssert)super.as(description));
    }

    @Override
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractObjectArrayAssert)super.as(description, args));
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (Object[])this.actual, expected);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF contains(ELEMENT ... values) {
        this.arrays.assertContains(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsOnly(ELEMENT ... values) {
        this.arrays.assertContainsOnly(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsOnlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF containsOnlyNulls() {
        this.arrays.assertContainsOnlyNulls(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameElementsAs(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnlyElementsOf((Iterable)iterable);
    }

    @Override
    public SELF containsOnlyOnce(ELEMENT ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsExactly(ELEMENT ... values) {
        this.arrays.assertContainsExactly(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrder(ELEMENT ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrderElementsOf(Iterable<? extends ELEMENT> values) {
        return (SELF)this.containsExactlyInAnyOrder((Object[])IterableUtil.toArray(values));
    }

    @Override
    public SELF containsExactlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF containsSequence(ELEMENT ... sequence) {
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSequence(ELEMENT ... sequence) {
        this.arrays.assertDoesNotContainSequence(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.arrays.assertDoesNotContainSequence(this.info, (Object[])this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(ELEMENT ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (Object[])this.actual, subsequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.arrays.assertContainsSubsequence(this.info, (Object[])this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSubsequence(ELEMENT ... subsequence) {
        this.arrays.assertDoesNotContainSubsequence(this.info, (Object[])this.actual, subsequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.arrays.assertDoesNotContainSubsequence(this.info, (Object[])this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF contains(ELEMENT value, Index index) {
        this.arrays.assertContains(this.info, (Object[])this.actual, value, index);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfTypes(Class<?> ... types) {
        this.arrays.assertHasOnlyElementsOfTypes(this.info, (Object[])this.actual, types);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContain(ELEMENT value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, value, index);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContain(ELEMENT ... values) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainAnyElementsOf(Iterable<? extends ELEMENT> iterable) {
        this.arrays.assertDoesNotContainAnyElementsOf(this.info, (Object[])this.actual, iterable);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF startsWith(ELEMENT ... sequence) {
        this.arrays.assertStartsWith(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT[] sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT first, ELEMENT ... sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, first, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSubsetOf(Iterable<? extends ELEMENT> values) {
        this.arrays.assertIsSubsetOf(this.info, this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSubsetOf(ELEMENT ... values) {
        this.arrays.assertIsSubsetOf(this.info, this.actual, java.util.Arrays.asList(values));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsNull() {
        this.arrays.assertContainsNull(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainNull() {
        this.arrays.assertDoesNotContainNull(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF are(Condition<? super ELEMENT> condition) {
        this.arrays.assertAre(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areNot(Condition<? super ELEMENT> condition) {
        this.arrays.assertAreNot(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF have(Condition<? super ELEMENT> condition) {
        this.arrays.assertHave(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doNotHave(Condition<? super ELEMENT> condition) {
        this.arrays.assertDoNotHave(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertAreAtLeast(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areAtLeastOne(Condition<? super ELEMENT> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areAtMost(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertAreAtMost(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areExactly(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertAreExactly(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF haveAtLeastOne(Condition<? super ELEMENT> condition) {
        return (SELF)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public SELF haveAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF haveAtMost(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF haveExactly(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasAtLeastOneElementOfType(Class<?> type) {
        this.arrays.assertHasAtLeastOneElementOfType(this.info, (Object[])this.actual, type);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfType(Class<?> type) {
        this.arrays.assertHasOnlyElementsOfType(this.info, (Object[])this.actual, type);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveAnyElementsOfTypes(Class<?> ... unexpectedTypes) {
        this.arrays.assertDoesNotHaveAnyElementsOfTypes(this.info, (Object[])this.actual, unexpectedTypes);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super ELEMENT> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (Object[])this.actual, comparator);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsAll(Iterable<? extends ELEMENT> iterable) {
        this.arrays.assertContainsAll(this.info, (Object[])this.actual, iterable);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super ELEMENT> elementComparator) {
        this.arrays = new ObjectArrays(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new ObjectArrayElementComparisonStrategy<ELEMENT>(elementComparator));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    private SELF usingExtendedByTypesElementComparator(Comparator<Object> elementComparator) {
        return (SELF)this.usingElementComparator((Comparator)new ExtendedByTypesComparator(elementComparator, this.comparatorsByType));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = ObjectArrays.instance();
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public <C> SELF usingComparatorForElementFieldsWithNames(Comparator<C> comparator, String ... elementPropertyOrFieldNames) {
        for (String elementPropertyOrField : elementPropertyOrFieldNames) {
            this.comparatorsForElementPropertyOrFieldNames.put(elementPropertyOrField, comparator);
        }
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public <C> SELF usingComparatorForElementFieldsWithType(Comparator<C> comparator, Class<C> type) {
        this.comparatorsForElementPropertyOrFieldTypes.put(type, comparator);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public <C> SELF usingComparatorForType(Comparator<C> comparator, Class<C> type) {
        if (this.arrays.getComparator() == null) {
            this.usingElementComparator((Comparator)new ExtendedByTypesComparator(this.comparatorsByType));
        }
        this.comparatorsForElementPropertyOrFieldTypes.put(type, comparator);
        this.comparatorsByType.put(type, comparator);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new FieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    @CheckReturnValue
    public SELF usingRecursiveFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new RecursiveFieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    @CheckReturnValue
    public SELF usingElementComparatorOnFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new OnFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    @CheckReturnValue
    public SELF usingElementComparatorIgnoringFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new IgnoringFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    @CheckReturnValue
    public ObjectArrayAssert<Object> extracting(String fieldOrProperty) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.byName(fieldOrProperty));
        String extractedDescription = Extractors.extractedDescriptionOf(fieldOrProperty);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> ObjectArrayAssert<P> extracting(String fieldOrProperty, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.byName(fieldOrProperty));
        String extractedDescription = Extractors.extractedDescriptionOf(fieldOrProperty);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public ObjectArrayAssert<Tuple> extracting(String ... propertiesOrFields) {
        Tuple[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.byName(propertiesOrFields));
        Tuple[] result = (Tuple[])java.util.Arrays.copyOf(values, values.length, Tuple[].class);
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Tuple>(result).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <U> ObjectArrayAssert<U> extracting(Extractor<? super ELEMENT, U> extractor) {
        U[] extracted = FieldsOrPropertiesExtractor.extract((Object[])this.actual, extractor);
        return new ObjectArrayAssert<U>(extracted);
    }

    @CheckReturnValue
    public <U, C extends Collection<U>> ObjectArrayAssert<U> flatExtracting(Extractor<? super ELEMENT, C> extractor) {
        List<Collection> extractedValues = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), extractor);
        ArrayList result = Lists.newArrayList();
        for (Collection e : extractedValues) {
            result.addAll(e);
        }
        return new ObjectArrayAssert(IterableUtil.toArray(result));
    }

    @CheckReturnValue
    public ObjectArrayAssert<Object> flatExtracting(String propertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), Extractors.byName(propertyName));
        for (Object group : extractedGroups) {
            if (Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return new ObjectArrayAssert<Object>(extractedValues.toArray());
    }

    @CheckReturnValue
    public ObjectArrayAssert<Object> extractingResultOf(String method) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> ObjectArrayAssert<P> extractingResultOf(String method, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractObjectArrayAssert)super.inHexadecimal());
    }

    @Override
    @CheckReturnValue
    public SELF inBinary() {
        return (SELF)((AbstractObjectArrayAssert)super.inBinary());
    }

    @CheckReturnValue
    public SELF filteredOn(String propertyOrFieldName, Object expectedValue) {
        Iterable<Object> filteredIterable = Filters.filter((Object[])this.actual).with(propertyOrFieldName, expectedValue).get();
        return (SELF)new ObjectArrayAssert<Object>(IterableUtil.toArray(filteredIterable));
    }

    @CheckReturnValue
    public SELF filteredOnNull(String propertyOrFieldName) {
        return this.filteredOn(propertyOrFieldName, (Object)null);
    }

    @CheckReturnValue
    public SELF filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters<Object> filter = Filters.filter((Object[])this.actual).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return (SELF)new ObjectArrayAssert<Object>(IterableUtil.toArray(filter.get()));
    }

    @CheckReturnValue
    public SELF filteredOn(Condition<? super ELEMENT> condition) {
        Iterable<? super ELEMENT> filteredIterable = Filters.filter((Object[])this.actual).being(condition).get();
        return (SELF)new ObjectArrayAssert<ELEMENT>(IterableUtil.toArray(filteredIterable));
    }

    @Override
    public SELF containsAnyOf(ELEMENT ... values) {
        this.arrays.assertContainsAnyOf(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsAnyElementsOf(Iterable<ELEMENT> iterable) {
        return (SELF)this.containsAnyOf((Object[])IterableUtil.toArray(iterable));
    }
}

