/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualCopy;

public class GraftedElement
extends TinyElementImpl {
    private NodeInfo externalNode;
    private VirtualCopy externalNodeCopy;

    public GraftedElement(TinyTree tree, int nodeNr, NodeInfo externalNode, boolean copyNamespaces) {
        super(tree, nodeNr);
        this.externalNode = externalNode;
        this.externalNodeCopy = VirtualCopy.makeVirtualCopy(externalNode, this);
        this.externalNodeCopy.setDropNamespaces(!copyNamespaces);
    }

    @Override
    public boolean hasChildNodes() {
        return this.externalNodeCopy.hasChildNodes();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.externalNode.getStringValueCS();
    }

    @Override
    public String getStringValue() {
        return this.externalNode.getStringValue();
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        return this.externalNode.atomize();
    }

    @Override
    public void copy(Receiver receiver, int copyOptions, Location location) throws XPathException {
        this.externalNodeCopy.copy(receiver, copyOptions, location);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
            case 1: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
            case 2: {
                return this.externalNodeCopy.iterateAxis(axisNumber, nodeTest);
            }
            case 3: {
                return this.externalNodeCopy.iterateAxis(axisNumber, nodeTest);
            }
            case 4: {
                return this.externalNodeCopy.iterateAxis(axisNumber, nodeTest);
            }
            case 5: {
                return this.externalNodeCopy.iterateAxis(axisNumber, nodeTest);
            }
            case 6: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
            case 7: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
            case 8: {
                return this.externalNodeCopy.iterateAxis(axisNumber, nodeTest);
            }
            case 9: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
            case 10: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
            case 11: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public String getAttributeValue(int fp) {
        NodeInfo actual = this.externalNodeCopy.getOriginalNode();
        if (actual instanceof TinyElementImpl) {
            return ((TinyElementImpl)actual).getAttributeValue(fp);
        }
        StructuredQName qn = this.getNamePool().getStructuredQName(fp);
        return actual.getAttributeValue(qn.getURI(), qn.getLocalPart());
    }
}

