/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.value.Cardinality;

public final class CardinalityCheckingIterator<T extends Item>
implements SequenceIterator<T> {
    private SequenceIterator<T> base;
    private Location locator;
    private T first = null;
    private T second = null;
    private int position = 0;

    public CardinalityCheckingIterator(SequenceIterator<T> base, int requiredCardinality, RoleDiagnostic role, Location locator) throws XPathException {
        this.base = base;
        this.locator = locator;
        this.first = base.next();
        if (this.first == null) {
            if (!Cardinality.allowsZero(requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
            }
        } else {
            if (requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + role.getMessage() + " is an empty sequence", role.getErrorCode());
            }
            this.second = base.next();
            if (this.second != null && !Cardinality.allowsMany(requiredCardinality)) {
                Item[] leaders = new Item[]{this.first, this.second};
                this.typeError("A sequence of more than one item is not allowed as the " + role.getMessage() + CardinalityChecker.depictSequenceStart(new ArrayIterator(leaders), 2), role.getErrorCode());
            }
        }
    }

    @Override
    public T next() throws XPathException {
        if (this.position < 2) {
            if (this.position == 0) {
                T current = this.first;
                this.position = this.first == null ? -1 : 1;
                return current;
            }
            if (this.position == 1) {
                T current = this.second;
                this.position = this.second == null ? -1 : 2;
                return current;
            }
            return null;
        }
        T current = this.base.next();
        this.position = current == null ? -1 : ++this.position;
        return current;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public int getProperties() {
        return 0;
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, errorCode, this.locator);
        e.setIsTypeError(!errorCode.startsWith("FORG"));
        throw e;
    }
}

