/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.xpath.MapBasedXPathVariableResolver;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class MapBasedXPathVariableResolverQName
implements XPathVariableResolver,
ICloneable<MapBasedXPathVariableResolverQName> {
    private final ICommonsMap<QName, Object> m_aMap;

    public MapBasedXPathVariableResolverQName() {
        this((Map)null);
    }

    public MapBasedXPathVariableResolverQName(@Nullable Map<QName, ?> map) {
        this.m_aMap = new CommonsHashMap(map);
    }

    public MapBasedXPathVariableResolverQName(@Nonnull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName) {
        ValueEnforcer.notNull(mapBasedXPathVariableResolverQName, "Other");
        this.m_aMap = (ICommonsMap)mapBasedXPathVariableResolverQName.m_aMap.getClone();
    }

    @Nonnull
    public EChange addUniqueVariable(@Nonnull QName qName, @Nonnull Object object) {
        ValueEnforcer.notNull(qName, "Name");
        ValueEnforcer.notNull(object, "Value");
        if (this.m_aMap.containsKey(qName)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put(qName, object);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName, boolean bl) {
        ValueEnforcer.notNull(mapBasedXPathVariableResolverQName, "Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolverQName.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put(entry.getKey(), entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathVariableResolver mapBasedXPathVariableResolver, boolean bl) {
        ValueEnforcer.notNull(mapBasedXPathVariableResolver, "Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolver.getAllVariables().entrySet()) {
            QName qName = new QName((String)entry.getKey());
            if (!bl && this.m_aMap.containsKey(qName)) continue;
            this.m_aMap.put(qName, entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange removeVariable(@Nullable QName qName) {
        if (qName == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aMap.removeObject(qName);
    }

    @Nonnull
    public EChange removeVariables(@Nullable Iterable<? extends QName> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (QName qName : iterable) {
                eChange = eChange.or(this.removeVariable(qName));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<QName, ?> getAllVariables() {
        return (ICommonsMap)this.m_aMap.getClone();
    }

    @Nonnegative
    public int getVariableCount() {
        return this.m_aMap.size();
    }

    @Nonnull
    public EChange clear() {
        return this.m_aMap.removeAll();
    }

    public void setAllVariables(@Nullable Map<QName, ?> map) {
        this.m_aMap.setAll(map);
    }

    @Override
    @Nullable
    public Object resolveVariable(@Nonnull QName qName) {
        ValueEnforcer.notNull(qName, "VariableName");
        return this.m_aMap.get(qName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedXPathVariableResolverQName getClone() {
        return new MapBasedXPathVariableResolverQName(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName = (MapBasedXPathVariableResolverQName)object;
        return EqualsHelper.equals(this.m_aMap, mapBasedXPathVariableResolverQName.m_aMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }
}

