/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.xpath.XPathFunctionKey;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;

@NotThreadSafe
public class MapBasedXPathFunctionResolver
implements XPathFunctionResolver,
ICloneable<MapBasedXPathFunctionResolver> {
    private final ICommonsOrderedMap<XPathFunctionKey, XPathFunction> m_aMap;

    public MapBasedXPathFunctionResolver() {
        this.m_aMap = new CommonsLinkedHashMap<XPathFunctionKey, XPathFunction>();
    }

    public MapBasedXPathFunctionResolver(@Nonnull MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver) {
        ValueEnforcer.notNull(mapBasedXPathFunctionResolver, "Other");
        this.m_aMap = mapBasedXPathFunctionResolver.m_aMap.getClone();
    }

    @Nonnull
    public EChange addUniqueFunction(@Nonnull String string, @Nonnull String string2, @Nonnegative int n, @Nonnull XPathFunction xPathFunction) {
        return this.addUniqueFunction(new QName(string, string2), n, xPathFunction);
    }

    @Nonnull
    public EChange addUniqueFunction(@Nonnull QName qName, @Nonnegative int n, @Nonnull XPathFunction xPathFunction) {
        ValueEnforcer.notNull(xPathFunction, "Function");
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        if (this.m_aMap.containsKey(xPathFunctionKey)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put(xPathFunctionKey, xPathFunction);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver, boolean bl) {
        ValueEnforcer.notNull(mapBasedXPathFunctionResolver, "Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathFunctionResolver.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put(entry.getKey(), entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange removeFunction(@Nonnull QName qName, @Nonnegative int n) {
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        return this.removeFunction(xPathFunctionKey);
    }

    @Nonnull
    public EChange removeFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        if (xPathFunctionKey == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aMap.removeObject(xPathFunctionKey);
    }

    @Nonnull
    public EChange removeFunctionsWithName(@Nullable QName qName) {
        EChange eChange = EChange.UNCHANGED;
        if (qName != null) {
            for (XPathFunctionKey xPathFunctionKey : this.m_aMap.copyOfKeySet()) {
                if (!xPathFunctionKey.getFunctionName().equals(qName)) continue;
                eChange = eChange.or(this.removeFunction(xPathFunctionKey));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<XPathFunctionKey, XPathFunction> getAllFunctions() {
        return this.m_aMap.getClone();
    }

    @Nonnegative
    public int getFunctionCount() {
        return this.m_aMap.size();
    }

    @Nonnull
    public EChange clear() {
        return this.m_aMap.removeAll();
    }

    @Override
    @Nullable
    public XPathFunction resolveFunction(@Nonnull QName qName, @Nonnegative int n) {
        return this.resolveFunction(new XPathFunctionKey(qName, n));
    }

    @Nullable
    public XPathFunction resolveFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        return (XPathFunction)this.m_aMap.get(xPathFunctionKey);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedXPathFunctionResolver getClone() {
        return new MapBasedXPathFunctionResolver(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver = (MapBasedXPathFunctionResolver)object;
        return EqualsHelper.equals(this.m_aMap, mapBasedXPathFunctionResolver.m_aMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }
}

