/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import com.helger.xml.transform.EXMLTransformTexts;
import com.helger.xml.transform.ITransformErrorListener;
import javax.annotation.Nonnull;
import javax.xml.transform.TransformerException;

public abstract class AbstractTransformErrorListener
implements ITransformErrorListener {
    @Nonnull
    private static IError _buildError(@Nonnull TransformerException transformerException, @Nonnull IErrorLevel iErrorLevel, @Nonnull IMultilingualText iMultilingualText) {
        SimpleLocation simpleLocation = SimpleLocation.create(transformerException.getLocator());
        return ((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builder().errorLevel(iErrorLevel)).errorLocation(simpleLocation)).errorText(iMultilingualText)).linkedException(transformerException)).build();
    }

    protected abstract void internalLog(@Nonnull IError var1);

    @Override
    public final void warning(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.WARN, EXMLTransformTexts.TRANSFORMATION_WARNING.getAsMLT()));
    }

    @Override
    public final void error(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.ERROR, EXMLTransformTexts.TRANSFORMATION_ERROR.getAsMLT()));
    }

    @Override
    public final void fatalError(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.FATAL_ERROR, EXMLTransformTexts.TRANSFORMATION_FATAL_ERROR.getAsMLT()));
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

