/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.exception.InitializationException;
import com.helger.commons.system.SystemProperties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SAXReaderFactory
implements Supplier<XMLReader> {
    @Override
    @Nonnull
    public XMLReader get() {
        return SAXReaderFactory.createXMLReader();
    }

    @Nonnull
    public static XMLReader createXMLReader() {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            SystemProperties.setPropertyValue("org.xml.sax.driver", xMLReader.getClass().getName());
            return xMLReader;
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new InitializationException("Failed to instantiate XML reader!", exception);
        }
    }
}

