/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.pool.IMutableObjectPool;
import com.helger.commons.pool.ObjectPool;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.timing.StopWatch;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@ThreadSafe
public final class SAXReader {
    private static final IMutableStatisticsHandlerTimer STATS_SAX_TIMER = StatisticsManager.getTimerHandler(SAXReader.class.getName());
    private static final IMutableStatisticsHandlerCounter STATS_SAX_SUCCESS_COUNTER = StatisticsManager.getCounterHandler(SAXReader.class.getName() + "$success");
    private static final IMutableStatisticsHandlerCounter STATS_SAX_ERROR_COUNTER = StatisticsManager.getCounterHandler(SAXReader.class.getName() + "$error");
    private static final IMutableObjectPool<XMLReader> POOL = new ObjectPool<XMLReader>(10, new SAXReaderFactory());
    private static final SAXReader INSTANCE = new SAXReader();

    private SAXReader() {
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull File file, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(file), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URI uRI, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRI), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URL uRL, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRL), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IHasInputStream iHasInputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iHasInputStream), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IReadableResource iReadableResource, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iReadableResource), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull CharSequence charSequence, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(charSequence), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull String string, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(string), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull ByteBuffer byteBuffer, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byteBuffer), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose InputStream inputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(inputStream), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose Reader reader, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull(reader, "Reader");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(reader), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputSource inputSource, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        block18: {
            ValueEnforcer.notNull(inputSource, "InputStream");
            ValueEnforcer.notNull(iSAXReaderSettings, "Settings");
            try {
                ESuccess eSuccess;
                block17: {
                    XMLReader xMLReader;
                    boolean bl = false;
                    if (iSAXReaderSettings.requiresNewXMLParser()) {
                        xMLReader = SAXReaderFactory.createXMLReader();
                    } else {
                        xMLReader = POOL.borrowObject();
                        bl = true;
                    }
                    try {
                        StopWatch stopWatch = StopWatch.createdStarted();
                        iSAXReaderSettings.applyToSAXReader(xMLReader);
                        xMLReader.parse(inputSource);
                        STATS_SAX_SUCCESS_COUNTER.increment();
                        STATS_SAX_TIMER.addTime(stopWatch.stopAndGetMillis());
                        eSuccess = ESuccess.SUCCESS;
                        if (!bl) break block17;
                        POOL.returnObject(xMLReader);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl) {
                                POOL.returnObject(xMLReader);
                            }
                            throw throwable;
                        }
                        catch (SAXParseException sAXParseException) {
                            boolean bl2 = false;
                            if (iSAXReaderSettings.getErrorHandler() != null) {
                                try {
                                    iSAXReaderSettings.getErrorHandler().fatalError(sAXParseException);
                                    bl2 = true;
                                }
                                catch (SAXException sAXException) {
                                    // empty catch block
                                }
                            }
                            if (!bl2) {
                                iSAXReaderSettings.exceptionCallbacks().forEach((Consumer<IExceptionCallback<Throwable>>)((Consumer<IExceptionCallback>)iExceptionCallback -> iExceptionCallback.onException(sAXParseException)));
                            }
                            StreamHelper.close(inputSource.getByteStream());
                            StreamHelper.close(inputSource.getCharacterStream());
                            break block18;
                        }
                        catch (Exception exception) {
                            iSAXReaderSettings.exceptionCallbacks().forEach((Consumer<IExceptionCallback<Throwable>>)((Consumer<IExceptionCallback>)iExceptionCallback -> iExceptionCallback.onException(exception)));
                            break block18;
                        }
                    }
                }
                return eSuccess;
            }
            finally {
                StreamHelper.close(inputSource.getByteStream());
                StreamHelper.close(inputSource.getCharacterStream());
            }
        }
        STATS_SAX_ERROR_COUNTER.increment();
        return ESuccess.FAILURE;
    }
}

