/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.IHasOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLMapHandler {
    public static final String ELEMENT_MAPPING = "mapping";
    public static final String ELEMENT_MAP = "map";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_VALUE = "value";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLMapHandler.class);
    private static final XMLMapHandler INSTANCE = new XMLMapHandler();

    private XMLMapHandler() {
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> readMap(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        return XMLMapHandler.readMap(iHasInputStream.getInputStream());
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IHasInputStream iHasInputStream, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        return XMLMapHandler.readMap(iHasInputStream.getInputStream(), map);
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> readMap(@Nonnull @WillClose InputStream inputStream) {
        CommonsHashMap<String, String> commonsHashMap = new CommonsHashMap<String, String>();
        if (XMLMapHandler.readMap(inputStream, commonsHashMap).isFailure()) {
            return null;
        }
        return commonsHashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static ESuccess readMap(@Nonnull @WillClose InputStream inputStream, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(map, "TargetMap");
        try (InputStream inputStream2 = inputStream;){
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream, (ISAXReaderSettings)new SAXReaderSettings().setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS));
            if (iMicroDocument == null) return ESuccess.FAILURE;
            XMLMapHandler.readMap(iMicroDocument.getDocumentElement(), map);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (Exception exception) {
            if (!LOGGER.isWarnEnabled()) return ESuccess.FAILURE;
            LOGGER.warn("Failed to read mapping resource '" + inputStream + "'", exception);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IMicroElement iMicroElement, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(iMicroElement, "ParentElement");
        ValueEnforcer.notNull(map, "TargetMap");
        try {
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_MAP)) {
                String string = iMicroElement2.getAttributeValue(ATTR_KEY);
                if (string == null) {
                    LOGGER.warn("Ignoring mapping element because key is null");
                    continue;
                }
                String string2 = iMicroElement2.getAttributeValue(ATTR_VALUE);
                if (string2 == null) {
                    LOGGER.warn("Ignoring mapping element because value is null");
                    continue;
                }
                if (map.containsKey(string) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Key '" + string + "' is already contained - overwriting!");
                }
                map.put(string, string2);
            }
            return ESuccess.SUCCESS;
        }
        catch (Exception exception) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to read mapping document", exception);
            }
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static IMicroDocument createMapDocument(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, "Map");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_MAPPING);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_MAP);
            iMicroElement2.setAttribute(ATTR_KEY, entry.getKey());
            iMicroElement2.setAttribute(ATTR_VALUE, entry.getValue());
        }
        return microDocument;
    }

    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> map, @Nonnull IHasOutputStream iHasOutputStream) {
        ValueEnforcer.notNull(iHasOutputStream, "OutputStreamProvider");
        return XMLMapHandler.writeMap(map, iHasOutputStream.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> map, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull(map, "Map");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            IMicroDocument iMicroDocument = XMLMapHandler.createMapDocument(map);
            ESuccess eSuccess = MicroWriter.writeToStream(iMicroDocument, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }
}

