/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.mutable.MutableInt;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IMicroAttributeContainer;
import com.helger.xml.microdom.IMicroNodeWithChildren;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMicroElement
extends IMicroNodeWithChildren,
IMicroAttributeContainer<IMicroElement> {
    @Nullable
    public String getNamespaceURI();

    @Nonnull
    public EChange setNamespaceURI(@Nullable String var1);

    default public boolean hasNamespaceURI() {
        return this.getNamespaceURI() != null;
    }

    default public boolean hasNoNamespaceURI() {
        return this.getNamespaceURI() == null;
    }

    default public boolean hasNamespaceURI(@Nullable String string) {
        return EqualsHelper.equals(this.getNamespaceURI(), string);
    }

    @Nullable
    public String getLocalName();

    default public boolean hasLocalName(@Nullable String string) {
        return EqualsHelper.equals(this.getLocalName(), string);
    }

    @Nonnull
    public String getTagName();

    default public boolean hasTagName(@Nullable String string) {
        return this.getTagName().equals(string);
    }

    default public boolean hasTagNameIgnoreCase(@Nullable String string) {
        return this.getTagName().equalsIgnoreCase(string);
    }

    @Nonnegative
    default public int getChildElementCount() {
        return this.getChildElementCount(null);
    }

    @Nonnegative
    default public int getChildElementCount(@Nullable Predicate<? super IMicroElement> predicate) {
        MutableInt mutableInt = new MutableInt(0);
        this.forAllChildElements(predicate, iMicroElement -> mutableInt.inc());
        return mutableInt.intValue();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements() {
        return this.getAllChildElements((Predicate<? super IMicroElement>)null);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements(@Nullable String string) {
        return this.getAllChildElements(IMicroElement.filterName(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements(@Nullable String string, @Nullable String string2) {
        return this.getAllChildElements(IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements(@Nullable Predicate<? super IMicroElement> predicate) {
        CommonsArrayList<IMicroElement> commonsArrayList = new CommonsArrayList<IMicroElement>();
        this.forAllChildElements(predicate, commonsArrayList::add);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllChildElementsRecursive();

    default public boolean hasChildElements() {
        return this.containsAnyChildElement(null);
    }

    default public boolean hasChildElements(@Nullable String string) {
        return this.containsAnyChildElement(IMicroElement.filterName(string));
    }

    default public boolean hasChildElements(@Nullable String string, @Nullable String string2) {
        return this.containsAnyChildElement(IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    public boolean containsAnyChildElement(@Nullable Predicate<? super IMicroElement> var1);

    @Nullable
    default public IMicroElement getFirstChildElement() {
        return this.getFirstChildElement((Predicate<? super IMicroElement>)null);
    }

    @Nullable
    default public IMicroElement getFirstChildElement(@Nullable String string) {
        return this.getFirstChildElement(IMicroElement.filterName(string));
    }

    @Nullable
    default public IMicroElement getFirstChildElement(@Nullable String string, @Nullable String string2) {
        return this.getFirstChildElement(IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    @Nullable
    public IMicroElement getFirstChildElement(@Nullable Predicate<? super IMicroElement> var1);

    default public void forAllChildElements(@Nonnull Consumer<? super IMicroElement> consumer) {
        this.forAllChildElements(null, consumer);
    }

    public void forAllChildElements(@Nullable Predicate<? super IMicroElement> var1, @Nonnull Consumer<? super IMicroElement> var2);

    @Nonnull
    default public EContinue forAllChildElementsBreakable(@Nonnull Function<? super IMicroElement, EContinue> function) {
        return this.forAllChildElementsBreakable(null, function);
    }

    @Nonnull
    public EContinue forAllChildElementsBreakable(@Nullable Predicate<? super IMicroElement> var1, @Nonnull Function<? super IMicroElement, EContinue> var2);

    @Override
    @Nonnull
    public IMicroElement getClone();

    @Nonnull
    public static Predicate<? super IMicroElement> filterNamespaceURI(@Nullable String string) {
        return iMicroElement -> iMicroElement.hasNamespaceURI(string);
    }

    @Nonnull
    public static Predicate<? super IMicroElement> filterName(@Nullable String string) {
        return iMicroElement -> iMicroElement.hasTagName(string);
    }

    @Nonnull
    public static Predicate<? super IMicroElement> filterNamespaceURIAndName(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return IMicroElement.filterName(string2);
        }
        return iMicroElement -> iMicroElement.hasNamespaceURI(string) && iMicroElement.hasLocalName(string2);
    }
}

