/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.svrl.AbstractSVRLMessage;
import com.helger.schematron.svrl.DefaultSVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.ISVRLLocationBeautifier;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLLocationBeautifierRegistry;
import com.helger.schematron.svrl.SVRLSuccessfulReport;
import com.helger.schematron.svrl.jaxb.DiagnosticReference;
import com.helger.schematron.svrl.jaxb.FailedAssert;
import com.helger.schematron.svrl.jaxb.PropertyReference;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.svrl.jaxb.SuccessfulReport;
import com.helger.schematron.svrl.jaxb.Text;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SVRLHelper {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static ISVRLErrorLevelDeterminator s_aELD = new DefaultSVRLErrorLevelDeterminator();
    private static final SVRLHelper INSTANCE = new SVRLHelper();

    private SVRLHelper() {
    }

    @Nullable
    public static String getAsString(@Nullable Text text) {
        if (text == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : text.getContent()) {
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLFailedAssert> getAllFailedAssertions(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList<SVRLFailedAssert> commonsArrayList = new CommonsArrayList<SVRLFailedAssert>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (!(object instanceof FailedAssert)) continue;
                commonsArrayList.add(new SVRLFailedAssert((FailedAssert)object));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLFailedAssert> getAllFailedAssertionsMoreOrEqualSevereThan(@Nullable SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        CommonsArrayList<SVRLFailedAssert> commonsArrayList = new CommonsArrayList<SVRLFailedAssert>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                SVRLFailedAssert sVRLFailedAssert;
                if (!(object instanceof FailedAssert) || !(sVRLFailedAssert = new SVRLFailedAssert((FailedAssert)object)).getFlag().isGE(iErrorLevel)) continue;
                commonsArrayList.add(sVRLFailedAssert);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReports(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList<SVRLSuccessfulReport> commonsArrayList = new CommonsArrayList<SVRLSuccessfulReport>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (!(object instanceof SuccessfulReport)) continue;
                commonsArrayList.add(new SVRLSuccessfulReport((SuccessfulReport)object));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReportsMoreOrEqualSevereThan(@Nullable SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        CommonsArrayList<SVRLSuccessfulReport> commonsArrayList = new CommonsArrayList<SVRLSuccessfulReport>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                SVRLSuccessfulReport sVRLSuccessfulReport;
                if (!(object instanceof SuccessfulReport) || !(sVRLSuccessfulReport = new SVRLSuccessfulReport((SuccessfulReport)object)).getFlag().isGE(iErrorLevel)) continue;
                commonsArrayList.add(sVRLSuccessfulReport);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<AbstractSVRLMessage> getAllFailedAssertionsAndSuccessfulReports(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList<AbstractSVRLMessage> commonsArrayList = new CommonsArrayList<AbstractSVRLMessage>();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (object instanceof FailedAssert) {
                    commonsArrayList.add(new SVRLFailedAssert((FailedAssert)object));
                    continue;
                }
                if (!(object instanceof SuccessfulReport)) continue;
                commonsArrayList.add(new SVRLSuccessfulReport((SuccessfulReport)object));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromFailedAssert(failedAssert);
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromSuccessfulReport(successfulReport);
    }

    @Nonnull
    public static ISVRLErrorLevelDeterminator getErrorLevelDeterminator() {
        return RW_LOCK.readLockedGet(() -> s_aELD);
    }

    public static void setErrorLevelDeterminator(@Nonnull ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator) {
        ValueEnforcer.notNull(iSVRLErrorLevelDeterminator, "ErrorLevelDeterminator");
        RW_LOCK.writeLockedGet(() -> {
            s_aELD = iSVRLErrorLevelDeterminator;
            return s_aELD;
        });
    }

    @Nonnull
    public static String getBeautifiedLocation(@Nonnull String string) {
        return SVRLHelper.getBeautifiedLocation(string, SVRLLocationBeautifierRegistry::getBeautifiedLocation);
    }

    @Nonnull
    public static String getBeautifiedLocation(@Nonnull String string, @Nonnull ISVRLLocationBeautifier iSVRLLocationBeautifier) {
        ValueEnforcer.notNull(string, "Location");
        ValueEnforcer.notNull(iSVRLLocationBeautifier, "LocationBeautifier");
        String string2 = string;
        Matcher matcher = RegExHelper.getMatcher("\\Q*:\\E([a-zA-Z0-9_]+)\\Q[namespace-uri()='\\E([^']+)\\Q']\\E", string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = iSVRLLocationBeautifier.getReplacementText(string4, string3);
            if (string5 == null) continue;
            string2 = StringHelper.replaceAll(string2, matcher.group(), string5);
        }
        return string2;
    }

    @Nonnull
    public static ICommonsList<DiagnosticReference> getAllDiagnosticReferences(@Nonnull FailedAssert failedAssert) {
        return CommonsArrayList.createFiltered(failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText(), DiagnosticReference.class::isInstance, DiagnosticReference.class::cast);
    }

    @Nonnull
    public static ICommonsList<PropertyReference> getAllPropertyReferences(@Nonnull FailedAssert failedAssert) {
        return CommonsArrayList.createFiltered(failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText(), PropertyReference.class::isInstance, PropertyReference.class::cast);
    }

    @Nonnull
    public static Text getText(@Nonnull FailedAssert failedAssert) {
        return CollectionHelper.findFirstMapped(failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText(), Text.class::isInstance, Text.class::cast);
    }

    @Nonnull
    public static ICommonsList<DiagnosticReference> getAllDiagnosticReferences(@Nonnull SuccessfulReport successfulReport) {
        return CommonsArrayList.createFiltered(successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText(), DiagnosticReference.class::isInstance, DiagnosticReference.class::cast);
    }

    @Nonnull
    public static ICommonsList<PropertyReference> getAllPropertyReferences(@Nonnull SuccessfulReport successfulReport) {
        return CommonsArrayList.createFiltered(successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText(), PropertyReference.class::isInstance, PropertyReference.class::cast);
    }

    @Nonnull
    public static Text getText(@Nonnull SuccessfulReport successfulReport) {
        return CollectionHelper.findFirstMapped(successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText(), Text.class::isInstance, Text.class::cast);
    }
}

