/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.svrl.SVRLResourceError;
import com.helger.schematron.svrl.jaxb.DiagnosticReference;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSVRLMessage {
    private final ICommonsList<DiagnosticReference> m_aDiagnosticReferences;
    private final String m_sText;
    private final String m_sID;
    private final String m_sLocation;
    private final String m_sTest;
    private final String m_sRole;
    private final IErrorLevel m_aFlag;

    public AbstractSVRLMessage(@Nullable List<DiagnosticReference> list, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable IErrorLevel iErrorLevel) {
        this.m_aDiagnosticReferences = new CommonsArrayList<List<DiagnosticReference>>(list);
        this.m_sID = StringHelper.trim(string);
        this.m_sText = StringHelper.trim(string2);
        this.m_sLocation = string3;
        this.m_sTest = string4;
        this.m_sRole = string5;
        this.m_aFlag = iErrorLevel;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<DiagnosticReference> getDiagnisticReferences() {
        return (ICommonsList)this.m_aDiagnosticReferences.getClone();
    }

    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Nullable
    public final String getText() {
        return this.m_sText;
    }

    @Nullable
    public final String getLocation() {
        return this.m_sLocation;
    }

    @Nullable
    public final String getTest() {
        return this.m_sTest;
    }

    @Nullable
    public final String getRole() {
        return this.m_sRole;
    }

    @Nonnull
    public final IErrorLevel getFlag() {
        return this.m_aFlag;
    }

    @Nonnull
    public SVRLResourceError getAsResourceError(@Nullable String string) {
        return ((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)new SVRLResourceError.SVRLErrorBuilder(this.m_sTest).errorLevel(this.m_aFlag)).errorID(this.m_sID)).errorFieldName(this.m_sLocation)).errorLocation(string)).errorText(this.m_sText)).build();
    }

    public String toString() {
        return new ToStringGenerator(this).append("DiagnosticRefs", this.m_aDiagnosticReferences).append("ID", this.m_sID).append("Text", this.m_sText).append("Location", this.m_sLocation).append("Test", this.m_sTest).appendIfNotNull("Role", this.m_sRole).append("Flag", this.m_aFlag).getToString();
    }
}

