/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.state.ESuccess;
import com.helger.commons.wrapper.Wrapper;
import com.helger.schematron.ISchematronErrorHandler;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.resolve.DefaultSchematronIncludeResolver;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Immutable
public final class SchematronHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronHelper.class);
    private static final SchematronHelper INSTANCE = new SchematronHelper();

    private SchematronHelper() {
    }

    public static boolean isDeprecatedSchematronNS(@Nullable String string) {
        return "http://www.ascc.net/xml/schematron".equals(string);
    }

    public static boolean isValidSchematronNS(@Nullable String string, boolean bl) {
        if ("http://purl.oclc.org/dsdl/schematron".equals(string)) {
            return true;
        }
        return bl && SchematronHelper.isDeprecatedSchematronNS(string);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllValidSchematronNS(boolean bl) {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(2);
        commonsArrayList.add("http://purl.oclc.org/dsdl/schematron");
        if (bl) {
            commonsArrayList.add("http://www.ascc.net/xml/schematron");
        }
        return commonsArrayList;
    }

    @Nullable
    @Deprecated
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iSchematronResource, "SchematronResource");
        ValueEnforcer.notNull(iReadableResource, "XMLSource");
        try {
            return iSchematronResource.applySchematronValidationToSVRL(iReadableResource);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to apply Schematron " + (String)iSchematronResource.getID() + " onto XML resource " + iReadableResource.getResourceID(), exception);
        }
    }

    @Deprecated
    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull Source source) {
        ValueEnforcer.notNull(iSchematronResource, "SchematronResource");
        ValueEnforcer.notNull(source, "XMLSource");
        try {
            return iSchematronResource.applySchematronValidationToSVRL(source);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to apply Schematron " + (String)iSchematronResource.getID() + " onto XML source " + source, exception);
        }
    }

    @Deprecated
    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull Node node) {
        ValueEnforcer.notNull(iSchematronResource, "SchematronResource");
        ValueEnforcer.notNull(node, "Node");
        return SchematronHelper.applySchematron(iSchematronResource, new DOMSource(node));
    }

    @Nonnull
    public static IErrorList convertToErrorList(@Nonnull SchematronOutputType schematronOutputType, @Nullable String string) {
        ValueEnforcer.notNull(schematronOutputType, "SchematronOutput");
        ErrorList errorList = new ErrorList();
        for (SVRLFailedAssert sVRLFailedAssert : SVRLHelper.getAllFailedAssertions(schematronOutputType)) {
            errorList.add(sVRLFailedAssert.getAsResourceError(string));
        }
        return errorList;
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static ESuccess _recursiveResolveAllSchematronIncludes(@Nonnull IMicroElement iMicroElement, @Nonnull IReadableResource iReadableResource, @Nullable ISAXReaderSettings iSAXReaderSettings, @Nonnull ISchematronErrorHandler iSchematronErrorHandler, boolean bl) {
        if (iMicroElement != null) {
            DefaultSchematronIncludeResolver defaultSchematronIncludeResolver = new DefaultSchematronIncludeResolver(iReadableResource);
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElementsRecursive()) {
                if (!SchematronHelper.isValidSchematronNS(iMicroElement2.getNamespaceURI(), bl) || !iMicroElement2.getLocalName().equals("include")) continue;
                String string = iMicroElement2.getAttributeValue("href");
                try {
                    IMicroElement iMicroElement3;
                    IMicroDocument iMicroDocument;
                    IReadableResource iReadableResource2;
                    int n = string.indexOf(35);
                    String string2 = null;
                    if (n >= 0) {
                        string2 = string.substring(n + 1);
                        string = string.substring(0, n);
                    }
                    if ((iReadableResource2 = defaultSchematronIncludeResolver.getResolvedSchematronResource(string)) == null) {
                        iSchematronErrorHandler.handleError(((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorLocation(new SimpleLocation(iReadableResource.getPath()))).errorText("Failed to resolve include '" + string + "'")).build());
                        return ESuccess.FAILURE;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolved '" + string + "' relative to '" + defaultSchematronIncludeResolver.getBaseHref() + "' as '" + iReadableResource2.getPath() + "'");
                    }
                    if ((iMicroDocument = MicroReader.readMicroXML(iReadableResource2, iSAXReaderSettings)) == null) {
                        iSchematronErrorHandler.handleError(((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorLocation(new SimpleLocation(iReadableResource.getPath()))).errorText("Failed to parse include " + iReadableResource2)).build());
                        return ESuccess.FAILURE;
                    }
                    if (string2 == null) {
                        iMicroElement3 = iMicroDocument.getDocumentElement();
                    } else {
                        final String string3 = string2;
                        final Wrapper wrapper = new Wrapper();
                        ChildrenProviderHierarchyVisitor.visitFrom(iMicroDocument.getDocumentElement(), new DefaultHierarchyVisitorCallback<IMicroNode>(){

                            @Override
                            public EHierarchyVisitorReturn onItemBeforeChildren(IMicroNode iMicroNode) {
                                IMicroElement iMicroElement;
                                String string;
                                if (iMicroNode.isElement() && string3.equals(string = (iMicroElement = (IMicroElement)iMicroNode).getAttributeValue("id"))) {
                                    wrapper.set(iMicroElement);
                                }
                                return EHierarchyVisitorReturn.CONTINUE;
                            }
                        }, true);
                        iMicroElement3 = (IMicroElement)wrapper.get();
                        if (iMicroElement3 == null) {
                            iSchematronErrorHandler.handleError(((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorLocation(new SimpleLocation(iReadableResource.getPath()))).errorText("Failed to resolve an element with the ID '" + string2 + "' in " + iReadableResource2 + "! Therefore including the whole document!")).build());
                            iMicroElement3 = iMicroDocument.getDocumentElement();
                        }
                    }
                    iMicroElement3.detachFromParent();
                    if (SchematronHelper.isValidSchematronNS(iMicroElement3.getNamespaceURI(), bl) && "schema".equals(iMicroElement3.getLocalName())) {
                        iSchematronErrorHandler.handleError(((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorLocation(new SimpleLocation(iReadableResource.getPath()))).errorText("The included resource " + iReadableResource2 + " seems to be a complete schema. To includes parts of a schema the respective element must be the root element of the included resource.")).build());
                    }
                    if (SchematronHelper._recursiveResolveAllSchematronIncludes(iMicroElement3, iReadableResource2, iSAXReaderSettings, iSchematronErrorHandler, bl).isFailure()) {
                        return ESuccess.FAILURE;
                    }
                    iMicroElement2.getParent().replaceChild(iMicroElement2, iMicroElement3);
                }
                catch (IOException iOException) {
                    iSchematronErrorHandler.handleError(((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorLocation(new SimpleLocation(iReadableResource.getPath()))).errorText("Failed to read include '" + string + "'")).linkedException(iOException)).build());
                    return ESuccess.FAILURE;
                }
            }
        }
        return ESuccess.SUCCESS;
    }

    @Nullable
    public static IMicroDocument getWithResolvedSchematronIncludes(@Nonnull IReadableResource iReadableResource, @Nonnull ISchematronErrorHandler iSchematronErrorHandler) {
        return SchematronHelper.getWithResolvedSchematronIncludes(iReadableResource, null, iSchematronErrorHandler, false);
    }

    @Nullable
    public static IMicroDocument getWithResolvedSchematronIncludes(@Nonnull IReadableResource iReadableResource, @Nullable ISAXReaderSettings iSAXReaderSettings, @Nonnull ISchematronErrorHandler iSchematronErrorHandler) {
        return SchematronHelper.getWithResolvedSchematronIncludes(iReadableResource, iSAXReaderSettings, iSchematronErrorHandler, false);
    }

    @Nullable
    public static IMicroDocument getWithResolvedSchematronIncludes(@Nonnull IReadableResource iReadableResource, @Nullable ISAXReaderSettings iSAXReaderSettings, @Nonnull ISchematronErrorHandler iSchematronErrorHandler, boolean bl) {
        InputSource inputSource = InputSourceFactory.create(iReadableResource);
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputSource, iSAXReaderSettings);
        if (iMicroDocument != null && SchematronHelper._recursiveResolveAllSchematronIncludes(iMicroDocument.getDocumentElement(), iReadableResource, iSAXReaderSettings, iSchematronErrorHandler, bl).isFailure()) {
            return null;
        }
        return iMicroDocument;
    }

    private static /* synthetic */ String lambda$_recursiveResolveAllSchematronIncludes$0(String string) {
        return "'" + string + "'";
    }
}

