/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBWriter;
import com.helger.jaxb.JAXBMarshallerHelper;
import com.helger.jaxb.builder.AbstractWritingJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import com.helger.jaxb.validation.LoggingValidationEventHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class JAXBWriterBuilder<JAXBTYPE, IMPLTYPE extends JAXBWriterBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractWritingJAXBBuilder<JAXBTYPE, IMPLTYPE>
implements IJAXBWriter<JAXBTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBWriterBuilder.class);
    private ValidationEventHandler m_aEventHandler = JAXBBuilderDefaultSettings.getDefaultValidationEventHandler();
    private NamespaceContext m_aNSContext = JAXBBuilderDefaultSettings.getDefaultNamespaceContext();
    private boolean m_bFormattedOutput = JAXBBuilderDefaultSettings.isDefaultFormattedOutput();
    private Charset m_aCharset = JAXBBuilderDefaultSettings.getDefaultCharset();
    private String m_sIndentString = JAXBBuilderDefaultSettings.getDefaultIndentString();
    private String m_sSchemaLocation = JAXBBuilderDefaultSettings.getDefaultSchemaLocation();
    private String m_sNoNamespaceSchemaLocation = JAXBBuilderDefaultSettings.getDefaultNoNamespaceSchemaLocation();

    public JAXBWriterBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        super(iJAXBDocumentType);
    }

    @Nullable
    public ValidationEventHandler getValidationEventHandler() {
        return this.m_aEventHandler;
    }

    @Nonnull
    public final IMPLTYPE setValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        this.m_aEventHandler = validationEventHandler;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public NamespaceContext getNamespaceContext() {
        return this.m_aNSContext;
    }

    @Nonnull
    public final IMPLTYPE setNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        this.m_aNSContext = namespaceContext;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    public boolean isFormattedOutput() {
        return this.m_bFormattedOutput;
    }

    @Nonnull
    public final IMPLTYPE setFormattedOutput(boolean bl) {
        this.m_bFormattedOutput = bl;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final IMPLTYPE setCharset(@Nullable Charset charset) {
        this.m_aCharset = charset;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public final IMPLTYPE setIndentString(@Nullable String string) {
        this.m_sIndentString = string;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public String getSchemaLocation() {
        return this.m_sSchemaLocation;
    }

    @Nonnull
    public final IMPLTYPE setSchemaLocation(@Nullable String string) {
        this.m_sSchemaLocation = string;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public String getNoNamespaceSchemaLocation() {
        return this.m_sNoNamespaceSchemaLocation;
    }

    @Nonnull
    public final IMPLTYPE setNoNamespaceSchemaLocation(@Nullable String string) {
        this.m_sNoNamespaceSchemaLocation = string;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nonnull
    protected Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller;
        block9: {
            marshaller = super.createMarshaller();
            if (this.m_aEventHandler != null) {
                marshaller.setEventHandler(this.m_aEventHandler);
            } else {
                marshaller.setEventHandler(new LoggingValidationEventHandler().andThen(marshaller.getEventHandler()));
            }
            if (this.m_aNSContext != null) {
                try {
                    JAXBMarshallerHelper.setSunNamespacePrefixMapper(marshaller, this.m_aNSContext);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    if (!LOGGER.isErrorEnabled()) break block9;
                    LOGGER.error("Failed to set the namespace context " + this.m_aNSContext + ": " + throwable.getClass().getName() + " -- " + throwable.getMessage());
                }
            }
        }
        JAXBMarshallerHelper.setFormattedOutput(marshaller, this.m_bFormattedOutput);
        if (this.m_aCharset != null) {
            JAXBMarshallerHelper.setEncoding(marshaller, this.m_aCharset);
        }
        if (this.m_sIndentString != null) {
            JAXBMarshallerHelper.setSunIndentString(marshaller, this.m_sIndentString);
        }
        if (this.m_sSchemaLocation != null) {
            JAXBMarshallerHelper.setSchemaLocation(marshaller, this.m_sSchemaLocation);
        }
        if (this.m_sNoNamespaceSchemaLocation != null) {
            JAXBMarshallerHelper.setNoNamespaceSchemaLocation(marshaller, this.m_sNoNamespaceSchemaLocation);
        }
        return marshaller;
    }

    @Override
    @Nonnull
    public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IJAXBWriter.IJAXBMarshaller<JAXBTYPE> iJAXBMarshaller) {
        ValueEnforcer.notNull(JAXBTYPE, "JAXBDocument");
        ValueEnforcer.notNull(iJAXBMarshaller, "MarshallerFunc");
        try {
            Marshaller marshaller = this.createMarshaller();
            Consumer<Marshaller> consumer = this.getMarshallerCustomizer();
            if (consumer != null) {
                consumer.accept(marshaller);
            }
            JAXBElement<JAXBTYPE> jAXBElement = this.createJAXBElement(JAXBTYPE);
            iJAXBMarshaller.doMarshal(marshaller, jAXBElement);
            return ESuccess.SUCCESS;
        }
        catch (JAXBException jAXBException) {
            this.exceptionCallbacks().forEach((Consumer<IExceptionCallback<JAXBException>>)((Consumer<IExceptionCallback>)iExceptionCallback -> iExceptionCallback.onException(jAXBException)));
            return ESuccess.FAILURE;
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("EventHandler", this.m_aEventHandler).append("NamespaceContext", this.m_aNSContext).append("FormattedOutput", this.m_bFormattedOutput).append("Charset", this.m_aCharset).append("IndentString", StringHelper.getHexEncoded(this.m_sIndentString, StandardCharsets.ISO_8859_1)).append("SchemaLocation", this.m_sSchemaLocation).append("NoNamespaceSchemaLocation", this.m_sNoNamespaceSchemaLocation).getToString();
    }
}

