/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.commons.datetime.PDTWebDateHelper;
import java.time.LocalDate;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterLocalDate
extends XmlAdapter<String, LocalDate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterLocalDate.class);

    @Override
    public LocalDate unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        LocalDate localDate = PDTWebDateHelper.getLocalDateFromXSD(string.trim());
        if (localDate == null) {
            LOGGER.warn("Failed to parse '" + string + "' to a LocalDate");
        }
        return localDate;
    }

    @Override
    public String marshal(@Nullable LocalDate localDate) {
        return PDTWebDateHelper.getAsStringXSD(localDate);
    }
}

