/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.callback.exception.IExceptionCallback;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class LoggingJAXBReadExceptionHandler
implements IExceptionCallback<JAXBException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingJAXBReadExceptionHandler.class);

    @Override
    public void onException(@Nonnull JAXBException jAXBException) {
        if (jAXBException instanceof UnmarshalException) {
            Throwable throwable = ((UnmarshalException)jAXBException).getLinkedException();
            if (throwable instanceof SAXParseException) {
                LOGGER.error("Failed to parse XML document: " + throwable.getMessage());
            } else {
                LOGGER.error("Unmarshal exception reading document", jAXBException);
            }
        } else {
            LOGGER.warn("JAXB Exception reading document", jAXBException);
        }
    }
}

