/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.jaxb.JAXBNamespacePrefixMapper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.namespace.NamespaceContext;

@Immutable
public final class JAXBMarshallerHelper {
    private static final String JAXB_EXTERNAL_CLASS_NAME = "com.sun.xml.bind.v2.runtime.MarshallerImpl";
    private static final String SUN_INDENT_STRING = "com.sun.xml.bind.indentString";
    private static final String SUN_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static final String SUN_ENCODING_HANDLER2 = "com.sun.xml.bind.marshaller.CharacterEscapeHandler";
    private static final String SUN_XML_HEADERS = "com.sun.xml.bind.xmlHeaders";
    private static final String SUN_C14N = "com.sun.xml.bind.c14n";
    private static final String SUN_OBJECT_IDENTITY_CYCLE_DETECTION = "com.sun.xml.bind.objectIdentitityCycleDetection";

    private JAXBMarshallerHelper() {
    }

    private static void _setProperty(@Nonnull Marshaller marshaller, @Nonnull String string, @Nullable Object object) {
        try {
            marshaller.setProperty(string, object);
        }
        catch (PropertyException propertyException) {
            throw new IllegalArgumentException("Failed to set JAXB property '" + string + "' to " + object, propertyException);
        }
    }

    @Nullable
    private static Object _getProperty(@Nonnull Marshaller marshaller, @Nonnull String string) {
        try {
            return marshaller.getProperty(string);
        }
        catch (PropertyException propertyException) {
            throw new IllegalArgumentException("Failed to get JAXB property '" + string + "'", propertyException);
        }
    }

    private static boolean _getBooleanProperty(@Nonnull Marshaller marshaller, @Nonnull String string) {
        return (Boolean)JAXBMarshallerHelper._getProperty(marshaller, string);
    }

    @Nullable
    private static String _getStringProperty(@Nonnull Marshaller marshaller, @Nonnull String string) {
        return (String)JAXBMarshallerHelper._getProperty(marshaller, string);
    }

    public static void setEncoding(@Nonnull Marshaller marshaller, @Nullable Charset charset) {
        JAXBMarshallerHelper.setEncoding(marshaller, charset == null ? null : charset.name());
    }

    public static void setEncoding(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.encoding", string);
    }

    @Nullable
    public static String getEncoding(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.encoding");
    }

    public static void setFormattedOutput(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.formatted.output", bl);
    }

    public static boolean isFormattedOutput(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, "jaxb.formatted.output");
    }

    public static void setSchemaLocation(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.schemaLocation", string);
    }

    @Nullable
    public static String getSchemaLocation(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.schemaLocation");
    }

    public static void setNoNamespaceSchemaLocation(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.noNamespaceSchemaLocation", string);
    }

    @Nullable
    public static String getNoNamespaceSchemaLocation(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.noNamespaceSchemaLocation");
    }

    public static void setFragment(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.fragment", bl);
    }

    public static boolean isFragment(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, "jaxb.fragment");
    }

    public static void setSunIndentString(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, SUN_INDENT_STRING, string);
    }

    @Nullable
    public static String getSunIndentString(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, SUN_INDENT_STRING);
    }

    public static void setSunCharacterEscapeHandler(@Nonnull Marshaller marshaller, @Nonnull Object object) {
        JAXBMarshallerHelper._setProperty(marshaller, SUN_ENCODING_HANDLER2, object);
    }

    @Nullable
    public static Object getSunCharacterEscapeHandler(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getProperty(marshaller, SUN_ENCODING_HANDLER2);
    }

    public static void setSunNamespacePrefixMapper(@Nonnull Marshaller marshaller, @Nonnull NamespaceContext namespaceContext) {
        JAXBNamespacePrefixMapper jAXBNamespacePrefixMapper = new JAXBNamespacePrefixMapper(namespaceContext);
        JAXBMarshallerHelper.setSunNamespacePrefixMapper(marshaller, jAXBNamespacePrefixMapper);
    }

    public static void setSunNamespacePrefixMapper(@Nonnull Marshaller marshaller, @Nonnull JAXBNamespacePrefixMapper jAXBNamespacePrefixMapper) {
        JAXBMarshallerHelper._setProperty(marshaller, SUN_PREFIX_MAPPER, jAXBNamespacePrefixMapper);
    }

    @Nullable
    public static JAXBNamespacePrefixMapper getSunNamespacePrefixMapper(@Nonnull Marshaller marshaller) {
        return (JAXBNamespacePrefixMapper)JAXBMarshallerHelper._getProperty(marshaller, SUN_PREFIX_MAPPER);
    }

    public static void setSunXMLHeaders(@Nonnull Marshaller marshaller, @Nonnull String string) {
        JAXBMarshallerHelper._setProperty(marshaller, SUN_XML_HEADERS, string);
    }

    @Nullable
    public static String getSunXMLHeaders(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, SUN_XML_HEADERS);
    }

    public static void setSunCanonicalization(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, SUN_C14N, bl);
    }

    public static boolean isSunCanonicalization(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, SUN_C14N);
    }

    public static void setSunObjectIdentityCycleDetection(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, SUN_OBJECT_IDENTITY_CYCLE_DETECTION, bl);
    }

    public static boolean isSunObjectIdentityCycleDetection(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, SUN_OBJECT_IDENTITY_CYCLE_DETECTION);
    }

    public static boolean isSunJAXB2Marshaller(@Nullable Marshaller marshaller) {
        if (marshaller == null) {
            return false;
        }
        String string = marshaller.getClass().getName();
        return string.equals(JAXB_EXTERNAL_CLASS_NAME);
    }
}

