/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.cache.Cache;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.jaxb.JAXBContextCacheKey;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlSchema;

@ThreadSafe
public final class JAXBContextCache
extends Cache<JAXBContextCacheKey, JAXBContext> {
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);
    private static boolean s_bDefaultInstantiated = false;

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    private JAXBContextCache() {
        super(jAXBContextCacheKey -> jAXBContextCacheKey.createJAXBContext(JAXBContextCache.isSilentMode()), 500, JAXBContextCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        JAXBContextCache jAXBContextCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return jAXBContextCache;
    }

    @Override
    @Nullable
    public JAXBContext getFromCache(@Nonnull Package package_) {
        return this.getFromCache(package_, (ClassLoader)null);
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        return (JAXBContext)this.getFromCache(new JAXBContextCacheKey(package_, classLoader));
    }

    @Override
    @Nullable
    public JAXBContext getFromCache(@Nonnull Class<?> clazz) {
        return this.getFromCache(clazz, (ClassLoader)null);
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Class<?> clazz, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull(clazz, "Class");
        Package package_ = clazz.getPackage();
        if (package_.getAnnotation(XmlSchema.class) != null) {
            return this.getFromCache(package_, classLoader);
        }
        return this.getFromCache(new CommonsArrayList(clazz), (Map)null);
    }

    @Override
    @Nullable
    public JAXBContext getFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList) {
        return this.getFromCache(iCommonsList, (Map)null);
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "Classes");
        return (JAXBContext)this.getFromCache(new JAXBContextCacheKey(iCommonsList, map));
    }

    @Override
    @Nonnull
    public EChange removeFromCache(@Nonnull Package package_) {
        return this.removeFromCache(package_, (ClassLoader)null);
    }

    @Nonnull
    public EChange removeFromCache(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        return this.removeFromCache(new JAXBContextCacheKey(package_, classLoader));
    }

    @Override
    @Nonnull
    public EChange removeFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList) {
        return this.removeFromCache(iCommonsList, (Map)null);
    }

    @Nonnull
    public EChange removeFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        return this.removeFromCache(new JAXBContextCacheKey(iCommonsList, map));
    }

    private static final class SingletonHolder {
        static final JAXBContextCache INSTANCE = new JAXBContextCache();

        private SingletonHolder() {
        }
    }
}

