/*
 * Decompiled with CFR 0.152.
 */
package com.helger.en16931.cii2ubl;

import com.helger.cii.d16b.CIID16BReader;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.datetime.PDTFromString;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.en16931.cii2ubl.EUBLCreationMode;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import un.unece.uncefact.data.standard.crossindustryinvoice._100.CrossIndustryInvoiceType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeSettlementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeTransactionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePartyType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementHeaderMonetarySummationType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;

public abstract class AbstractCIIToUBLConverter<IMPLTYPE extends AbstractCIIToUBLConverter<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    public static final EUBLCreationMode DEFAULT_UBL_CREATION_MODE = EUBLCreationMode.AUTOMATIC;
    public static final String DEFAULT_VAT_SCHEME = "VAT";
    public static final String DEFAULT_CUSTOMIZATION_ID = "urn:cen.eu:en16931:2017#compliant#urn:fdc:peppol.eu:2017:poacc:billing:3.0";
    public static final String DEFAULT_PROFILE_ID = "urn:fdc:peppol.eu:2017:poacc:billing:01:1.0";
    public static final String DEFAULT_CARD_ACCOUNT_NETWORK_ID = "mapped-from-cii";
    public static final boolean DEFAULT_SWAP_QUANTITY_SIGN_IF_NEEDED = true;
    public static final boolean DEFAULT_SWAP_PRICE_SIGN_IF_NEEDED = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCIIToUBLConverter.class);
    private static final ICommonsSet<String> CREDIT_NOTE_TYPE_CODES = StringHelper.getExplodedToSet(" ", "81 83 261 262 296 308 381 396 420 458 532");
    private static final ICommonsSet<String> INVOICE_TYPE_CODES = StringHelper.getExplodedToSet(" ", "80 82 84 130 202 203 204 211 295 325 326 380 383 384 385 386 387 388 389 390 393 394 395 456 457 527 575 623 633 751 780 935");
    private EUBLCreationMode m_eCreationMode = DEFAULT_UBL_CREATION_MODE;
    private String m_sVATScheme = "VAT";
    private String m_sCustomizationID = "urn:cen.eu:en16931:2017#compliant#urn:fdc:peppol.eu:2017:poacc:billing:3.0";
    private String m_sProfileID = "urn:fdc:peppol.eu:2017:poacc:billing:01:1.0";
    private String m_sCardAccountNetworkID = "mapped-from-cii";
    private boolean m_bSwapQuantitySignIfNeeded = true;
    private boolean m_bSwapPriceSignIfNeeded = true;

    protected AbstractCIIToUBLConverter() {
    }

    protected static <T> boolean ifNotNull(@Nonnull Consumer<? super T> consumer, @Nullable T t) {
        if (t == null) {
            return false;
        }
        consumer.accept(t);
        return true;
    }

    protected static boolean ifNotEmpty(@Nonnull Consumer<? super String> consumer, @Nullable String string) {
        if (string == null) {
            return false;
        }
        consumer.accept(string);
        return true;
    }

    @Nonnull
    public final EUBLCreationMode getUBLCreationMode() {
        return this.m_eCreationMode;
    }

    @Nonnull
    public final IMPLTYPE setUBLCreationMode(@Nonnull EUBLCreationMode eUBLCreationMode) {
        ValueEnforcer.notNull(eUBLCreationMode, "CreationMode");
        this.m_eCreationMode = eUBLCreationMode;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getVATScheme() {
        return this.m_sVATScheme;
    }

    @Nonnull
    public final IMPLTYPE setVATScheme(@Nonnull String string) {
        ValueEnforcer.notNull(string, "VATScheme");
        this.m_sVATScheme = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getCustomizationID() {
        return this.m_sCustomizationID;
    }

    @Nonnull
    public final IMPLTYPE setCustomizationID(@Nonnull String string) {
        ValueEnforcer.notNull(string, "CustomizationID");
        this.m_sCustomizationID = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getProfileID() {
        return this.m_sProfileID;
    }

    @Nonnull
    public final IMPLTYPE setProfileID(@Nonnull String string) {
        ValueEnforcer.notNull(string, "ProfileID");
        this.m_sProfileID = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getCardAccountNetworkID() {
        return this.m_sCardAccountNetworkID;
    }

    @Nonnull
    public final IMPLTYPE setCardAccountNetworkID(@Nonnull String string) {
        ValueEnforcer.notNull(string, "CardAccountNetworkID");
        this.m_sCardAccountNetworkID = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    public final boolean isSwapQuantitySignIfNeeded() {
        return this.m_bSwapQuantitySignIfNeeded;
    }

    @Nonnull
    public final IMPLTYPE setSwapQuantitySignIfNeeded(boolean bl) {
        this.m_bSwapQuantitySignIfNeeded = bl;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    public final boolean isSwapPriceSignIfNeeded() {
        return this.m_bSwapPriceSignIfNeeded;
    }

    @Nonnull
    public final IMPLTYPE setSwapPriceSignIfNeeded(boolean bl) {
        this.m_bSwapPriceSignIfNeeded = bl;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    protected static IError _buildError(@Nullable String[] stringArray, String string) {
        return ((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorText(string)).errorFieldName(stringArray == null ? null : StringHelper.getImploded('/', stringArray))).build();
    }

    @Nullable
    protected static String _getDatePattern(@Nonnull @Nonempty String string, @Nonnull IErrorList iErrorList) {
        ValueEnforcer.notEmpty(string, "Format");
        ValueEnforcer.notNull(iErrorList, "ErrorList");
        switch (string) {
            case "2": {
                return "ddMMuu";
            }
            case "3": {
                return "MMdduu";
            }
            case "4": {
                return "ddMMuuuu";
            }
            case "101": {
                return "uuMMdd";
            }
            case "102": {
                return "uuuuMMdd";
            }
            case "103": {
                return "YYwwee";
            }
            case "105": {
                return "uuDDD";
            }
        }
        iErrorList.add(AbstractCIIToUBLConverter._buildError(null, "Unsupported date format '" + string + "'"));
        return null;
    }

    @Nullable
    protected static LocalDate parseDate(@Nullable String string, @Nullable String string2, @Nonnull IErrorList iErrorList) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string3 = StringHelper.getNotEmpty(string2, "102");
        String string4 = AbstractCIIToUBLConverter._getDatePattern(string3, iErrorList);
        if (string4 == null) {
            return null;
        }
        LocalDate localDate = PDTFromString.getLocalDateFromString(string, string4);
        if (localDate == null) {
            iErrorList.add(AbstractCIIToUBLConverter._buildError(null, "Failed to parse the date '" + string + "' using format '" + string3 + "'"));
        }
        return localDate;
    }

    @Nullable
    protected static LocalDate _parseDate(@Nullable DateTimeType.DateTimeString dateTimeString, @Nonnull IErrorList iErrorList) {
        if (dateTimeString == null) {
            return null;
        }
        return AbstractCIIToUBLConverter.parseDate(dateTimeString.getValue(), dateTimeString.getFormat(), iErrorList);
    }

    @Nullable
    protected static LocalDate _parseDate(@Nullable FormattedDateTimeType.DateTimeString dateTimeString, @Nonnull IErrorList iErrorList) {
        if (dateTimeString == null) {
            return null;
        }
        return AbstractCIIToUBLConverter.parseDate(dateTimeString.getValue(), dateTimeString.getFormat(), iErrorList);
    }

    @Nullable
    protected static LocalDate _parseDate(@Nullable DateType.DateString dateString, @Nonnull IErrorList iErrorList) {
        if (dateString == null) {
            return null;
        }
        return AbstractCIIToUBLConverter.parseDate(dateString.getValue(), dateString.getFormat(), iErrorList);
    }

    @Nonnull
    protected static ETriState _parseIndicator(@Nullable IndicatorType indicatorType, @Nonnull IErrorList iErrorList) {
        if (indicatorType == null) {
            return ETriState.UNDEFINED;
        }
        if (indicatorType.isIndicator() != null) {
            return ETriState.valueOf((boolean)indicatorType.isIndicator());
        }
        if (indicatorType.getIndicatorString() != null) {
            String string = indicatorType.getIndicatorStringValue();
            if (string == null) {
                return ETriState.UNDEFINED;
            }
            if ("true".equals(string)) {
                return ETriState.TRUE;
            }
            if ("false".equals(string)) {
                return ETriState.FALSE;
            }
            iErrorList.add(AbstractCIIToUBLConverter._buildError(null, "Failed to parse the indicator value '" + indicatorType + "' to a boolean value."));
            return ETriState.UNDEFINED;
        }
        throw new IllegalStateException("Indicator has neither string nor boolen");
    }

    @Nullable
    protected static <T extends IdentifierType> T _copyID(@Nullable IDType iDType, @Nonnull T t) {
        if (iDType == null) {
            return null;
        }
        if (StringHelper.hasNoText(iDType.getValue())) {
            return null;
        }
        t.setValue(iDType.getValue());
        t.setSchemeID(iDType.getSchemeID());
        t.setSchemeName(iDType.getSchemeName());
        t.setSchemeAgencyID(iDType.getSchemeAgencyID());
        t.setSchemeAgencyName(iDType.getSchemeAgencyName());
        t.setSchemeVersionID(iDType.getSchemeVersionID());
        t.setSchemeDataURI(iDType.getSchemeDataURI());
        t.setSchemeURI(iDType.getSchemeURI());
        return t;
    }

    @Nullable
    protected static <T extends TextType> T _copyName(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType, @Nonnull T t) {
        if (textType == null) {
            return null;
        }
        if (StringHelper.hasNoText(textType.getValue())) {
            return null;
        }
        t.setValue(textType.getValue());
        t.setLanguageID(textType.getLanguageID());
        t.setLanguageLocaleID(textType.getLanguageLocaleID());
        return t;
    }

    @Nullable
    protected static <T extends CodeType> T _copyCode(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType codeType, @Nonnull T t) {
        if (codeType == null) {
            return null;
        }
        if (StringHelper.hasNoText(codeType.getValue())) {
            return null;
        }
        t.setValue(codeType.getValue());
        t.setListID(codeType.getListID());
        t.setListAgencyID(codeType.getListAgencyID());
        t.setListAgencyName(codeType.getListAgencyName());
        t.setListName(codeType.getListName());
        t.setListVersionID(codeType.getListVersionID());
        t.setName(codeType.getName());
        t.setLanguageID(codeType.getLanguageID());
        t.setListURI(codeType.getListURI());
        t.setListSchemeURI(codeType.getListSchemeURI());
        return t;
    }

    @Nullable
    protected static <T extends com.helger.xsds.ccts.cct.schemamodule.QuantityType> T _copyQuantity(@Nullable QuantityType quantityType, @Nonnull T t) {
        if (quantityType == null) {
            return null;
        }
        if (quantityType.getValue() == null) {
            return null;
        }
        t.setValue(MathHelper.getWithoutTrailingZeroes(quantityType.getValue()));
        t.setUnitCode(quantityType.getUnitCode());
        t.setUnitCodeListID(quantityType.getUnitCodeListID());
        t.setUnitCodeListAgencyID(quantityType.getUnitCodeListAgencyID());
        t.setUnitCodeListAgencyName(quantityType.getUnitCodeListAgencyName());
        return t;
    }

    @Nullable
    protected static <T extends com.helger.xsds.ccts.cct.schemamodule.AmountType> T _copyAmount(@Nullable AmountType amountType, @Nonnull T t, @Nullable String string) {
        if (amountType == null) {
            return null;
        }
        if (amountType.getValue() == null) {
            return null;
        }
        t.setValue(MathHelper.getWithoutTrailingZeroes(amountType.getValue()));
        t.setCurrencyID(amountType.getCurrencyID());
        if (StringHelper.hasNoText(t.getCurrencyID())) {
            t.setCurrencyID(string);
        }
        t.setCurrencyCodeListVersionID(amountType.getCurrencyCodeListVersionID());
        return t;
    }

    protected static boolean isPaymentMeansCodeCreditTransfer(@Nullable String string) {
        return "30".equals(string) || "42".equals(string) || "58".equals(string);
    }

    protected static boolean isPaymentMeansCodePaymentCard(@Nullable String string) {
        return "48".equals(string);
    }

    protected static boolean isPaymentMeansCodeDirectDebit(@Nullable String string) {
        return "49".equals(string) || "59".equals(string);
    }

    protected static boolean isPaymentMeansCodeOtherKnown(@Nullable String string) {
        return "1".equals(string) || "57".equals(string) || "68".equals(string);
    }

    protected static boolean isOriginatorDocumentReferenceTypeCode(@Nullable String string) {
        return "50".equals(string);
    }

    protected static boolean isValidDocumentReferenceTypeCode(@Nullable String string) {
        return AbstractCIIToUBLConverter.isOriginatorDocumentReferenceTypeCode(string) || "130".equals(string);
    }

    protected static boolean isLT0Strict(@Nullable BigDecimal bigDecimal) {
        return bigDecimal != null && MathHelper.isLT0(bigDecimal);
    }

    protected static boolean canUseGlobalID(@Nonnull TradePartyType tradePartyType) {
        if (tradePartyType.hasGlobalIDEntries()) {
            for (IDType iDType : tradePartyType.getGlobalID()) {
                if (!StringHelper.hasText(iDType.getValue()) || !StringHelper.hasText(iDType.getSchemeID())) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    protected static ICommonsList<IDType> getAllUsableGlobalIDs(@Nonnull TradePartyType tradePartyType) {
        return CommonsArrayList.createFiltered(tradePartyType.getGlobalID(), iDType -> StringHelper.hasText(iDType.getValue()) && StringHelper.hasText(iDType.getSchemeID()));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void swapQuantityAndPriceIfNeeded(boolean bl, @Nonnull BigDecimal bigDecimal, @Nonnull Consumer<BigDecimal> consumer, @Nullable BigDecimal bigDecimal2, @Nullable Consumer<BigDecimal> consumer2) {
        boolean bl2;
        boolean bl3 = bl2 = bigDecimal2 != null && consumer2 != null;
        if (bl) {
            boolean bl4;
            boolean bl5 = MathHelper.isGE0(bigDecimal);
            boolean bl6 = bl4 = !bl5;
            if (!bl2) {
                if (!bl5) return;
                LOGGER.warn("A negative line extension amount with quantity " + bigDecimal + " looks interesting.");
                return;
            }
            boolean bl7 = MathHelper.isLT0(bigDecimal2);
            if (bl4 == bl7) {
                LOGGER.warn("A negative line extension amount with quantity " + bigDecimal + " and price " + bigDecimal2 + " looks interesting.");
                return;
            }
            if (bl7) {
                if (this.isSwapQuantitySignIfNeeded()) {
                    consumer.accept(bigDecimal.negate());
                } else {
                    LOGGER.info("Swapping of the quantity sign is disabled, so not doing it");
                }
                if (this.isSwapPriceSignIfNeeded()) {
                    consumer2.accept(bigDecimal2.negate());
                    return;
                }
                LOGGER.info("Swapping of the price sign is disabled, so not doing it");
                return;
            }
            if (!bl4) return;
            return;
        } else {
            boolean bl8 = MathHelper.isLT0(bigDecimal);
            if (bl2) {
                boolean bl9 = MathHelper.isLT0(bigDecimal2);
                if (bl8 && bl9) {
                    if (this.isSwapQuantitySignIfNeeded()) {
                        consumer.accept(bigDecimal.negate());
                    } else {
                        LOGGER.info("Swapping of the quantity sign is disabled, so not doing it");
                    }
                    if (this.isSwapPriceSignIfNeeded()) {
                        consumer2.accept(bigDecimal2.negate());
                        return;
                    }
                    LOGGER.info("Swapping of the price sign is disabled, so not doing it");
                    return;
                }
                if (!bl8) {
                    if (!bl9) return;
                }
                LOGGER.warn("A positive line extension amount with quantity " + bigDecimal + " and price " + bigDecimal2 + " looks interesting.");
                return;
            }
            if (!bl8) return;
            LOGGER.warn("A positive line extension amount with quantity " + bigDecimal + " looks interesting.");
        }
    }

    @Nonnull
    protected static ETriState isInvoiceType(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType) {
        AmountType amountType;
        String string;
        ETriState eTriState = ETriState.UNDEFINED;
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        if (exchangedDocumentType != null) {
            string = StringHelper.trim(exchangedDocumentType.getTypeCodeValue());
            if (INVOICE_TYPE_CODES.contains(string)) {
                eTriState = ETriState.TRUE;
            } else if (CREDIT_NOTE_TYPE_CODES.contains(string)) {
                eTriState = ETriState.FALSE;
            }
        } else {
            string = null;
        }
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType == null ? null : supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        TradeSettlementHeaderMonetarySummationType tradeSettlementHeaderMonetarySummationType = headerTradeSettlementType == null ? null : headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        AmountType amountType2 = amountType = tradeSettlementHeaderMonetarySummationType == null || tradeSettlementHeaderMonetarySummationType.hasNoDuePayableAmountEntries() ? null : tradeSettlementHeaderMonetarySummationType.getDuePayableAmount().get(0);
        if (eTriState.isUndefined() && amountType != null) {
            eTriState = ETriState.valueOf(MathHelper.isGE0(amountType.getValue()));
        }
        if (eTriState.isUndefined()) {
            LOGGER.warn("Could not determine, if the provided CII document is an Invoice or a CreditNote. TypeCode =is '" + string + "'; DuePayable = " + amountType);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Determined the provided CII document to be " + (eTriState.isTrue() ? "an Invoice" : "a CreditNote"));
        }
        return eTriState;
    }

    @Nullable
    public Serializable convertCIItoUBL(@Nonnull File file, @Nonnull ErrorList errorList) {
        CrossIndustryInvoiceType crossIndustryInvoiceType = (CrossIndustryInvoiceType)((CIID16BReader)CIID16BReader.crossIndustryInvoice().setValidationEventHandler(new WrappedCollectingValidationEventHandler(errorList))).read(file);
        if (crossIndustryInvoiceType == null) {
            return null;
        }
        return this.convertCIItoUBL(crossIndustryInvoiceType, errorList);
    }

    @Nullable
    public abstract Serializable convertCIItoUBL(@Nonnull CrossIndustryInvoiceType var1, @Nonnull ErrorList var2);

    static {
        INVOICE_TYPE_CODES.add("875");
        INVOICE_TYPE_CODES.add("876");
        INVOICE_TYPE_CODES.add("877");
    }
}

