/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.query.from;

import java.util.ArrayList;
import java.util.List;
import org.mule.tools.soql.SOQLDataVisitor;
import org.mule.tools.soql.query.SOQLAbstractData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSpec
extends SOQLAbstractData {
    private List<String> objectPrefixNames = new ArrayList<String>();
    private String objectName;
    private String alias;

    public ObjectSpec() {
    }

    public ObjectSpec(String objectName, String alias) {
        this.objectName = objectName;
        this.alias = alias;
    }

    @Override
    public String toSOQLText() {
        StringBuilder sb = new StringBuilder();
        if (this.objectPrefixNames != null) {
            for (String objectName : this.objectPrefixNames) {
                sb.append(objectName).append(".");
            }
        }
        if (this.objectName != null) {
            sb.append(this.objectName);
        }
        if (this.alias != null) {
            sb.append(" ").append(this.alias);
        }
        return sb.toString();
    }

    @Override
    public <T> T accept(SOQLDataVisitor<? extends T> soqlDataVisitor) {
        return soqlDataVisitor.visitObjectSpec(this);
    }

    public void addObjectPrefixName(String objectPrefixName) {
        if (objectPrefixName == null) {
            return;
        }
        if (this.objectPrefixNames == null) {
            this.objectPrefixNames = new ArrayList<String>();
        }
        this.objectPrefixNames.add(objectPrefixName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public List<String> getObjectPrefixNames() {
        return this.objectPrefixNames;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

