/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.query.data;

import java.util.ArrayList;
import java.util.List;
import org.mule.tools.soql.SOQLDataVisitor;
import org.mule.tools.soql.query.SOQLAbstractData;
import org.mule.tools.soql.query.condition.ConditionField;
import org.mule.tools.soql.query.data.FunctionParameter;
import org.mule.tools.soql.query.group.GroupBySpec;
import org.mule.tools.soql.query.order.OrderByField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCall
extends SOQLAbstractData
implements FunctionParameter,
ConditionField,
OrderByField,
GroupBySpec {
    private String functionName;
    private List<FunctionParameter> functionParameters = new ArrayList<FunctionParameter>();

    public FunctionCall() {
    }

    public FunctionCall(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public String toSOQLText() {
        StringBuilder sb = new StringBuilder();
        if (this.functionName != null) {
            sb.append(this.functionName);
        }
        sb.append("(");
        sb.append(this.createSOQLListText(this.functionParameters, ","));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public <T> T accept(SOQLDataVisitor<? extends T> soqlDataVisitor) {
        return soqlDataVisitor.visitFunctionCall(this);
    }

    public void addFunctionParameter(FunctionParameter functionParameter) {
        if (functionParameter == null) {
            return;
        }
        if (this.functionParameters == null) {
            this.functionParameters = new ArrayList<FunctionParameter>();
        }
        this.functionParameters.add(functionParameter);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public List<FunctionParameter> getFunctionParameters() {
        return this.functionParameters;
    }
}

