/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.parser;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.utils.SOQLCommonTreeUtils;
import org.mule.tools.soql.query.order.OrderByDirection;
import org.mule.tools.soql.query.order.OrderByField;
import org.mule.tools.soql.query.order.OrderByNulls;
import org.mule.tools.soql.query.order.OrderBySpec;

public class OrderBySpecNode
extends SOQLCommonTree {
    public OrderBySpecNode(int tokenType) {
        super((Token)new CommonToken(tokenType, "ORDER_BY_SPEC"));
    }

    public OrderBySpec createSOQLData() {
        OrderBySpec orderBySpec = new OrderBySpec();
        this.processFirstNode(orderBySpec);
        this.processSecondNode(orderBySpec);
        this.processThirdNode(orderBySpec);
        return orderBySpec;
    }

    private void processFirstNode(OrderBySpec orderBySpec) {
        CommonTree child = (CommonTree)this.getChild(0);
        if (child == null) {
            return;
        }
        this.fillOrderByField(child, orderBySpec);
    }

    private void processSecondNode(OrderBySpec orderBySpec) {
        CommonTree child = (CommonTree)this.getChild(1);
        if (child == null) {
            return;
        }
        if (SOQLCommonTreeUtils.matchesAnyType(child, 8, 37).booleanValue()) {
            this.fillOrderByDirection(child, orderBySpec);
        } else if (SOQLCommonTreeUtils.matchesAnyType(child, 122).booleanValue()) {
            this.fillOrderByNulls(child, orderBySpec);
        }
    }

    private void processThirdNode(OrderBySpec orderBySpec) {
        CommonTree child = (CommonTree)this.getChild(2);
        if (child == null) {
            return;
        }
        this.fillOrderByNulls(child, orderBySpec);
    }

    private void fillOrderByField(CommonTree node, OrderBySpec orderBySpec) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 47, 57).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        orderBySpec.setOrderByField((OrderByField)soqlNode.createSOQLData());
    }

    private void fillOrderByDirection(CommonTree node, OrderBySpec orderBySpec) {
        OrderByDirection orderByDirection = OrderByDirection.get(node.getText());
        if (orderByDirection == null) {
            return;
        }
        orderBySpec.setDirection(orderByDirection);
    }

    private void fillOrderByNulls(CommonTree node, OrderBySpec orderBySpec) {
        CommonTree child = (CommonTree)node.getChild(0);
        OrderByNulls orderByNulls = OrderByNulls.get(child.getText());
        if (orderByNulls == null) {
            return;
        }
        orderBySpec.setNulls(orderByNulls);
    }
}

